# This script was automatically generated from the dsa-1309
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the PostgreSQL database performs insufficient
validation of variables passed to privileged SQL statements, so called
<q>security definers</q>, which could lead to SQL privilege escalation.
The oldstable distribution (sarge) doesn\'t contain PostgreSQL 8.1.
For the stable distribution (etch) this problem has been fixed in
version 8.1.9-0etch1.
For the unstable distribution (sid) this problem has been fixed in
version 8.1.9-1.
We recommend that you upgrade your PostgreSQL packages.


Solution : http://www.debian.org/security/2007/dsa-1309
Risk factor : High';

if (description) {
 script_id(25531);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1309");
 script_cve_id("CVE-2007-2138");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1309] DSA-1309-1 postgresql-8.1");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1309-1 postgresql-8.1");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libecpg-compat2', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-compat2 is vulnerable in Debian 4.0.\nUpgrade to libecpg-compat2_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'libecpg-dev', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-dev is vulnerable in Debian 4.0.\nUpgrade to libecpg-dev_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'libecpg5', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg5 is vulnerable in Debian 4.0.\nUpgrade to libecpg5_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'libpgtypes2', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtypes2 is vulnerable in Debian 4.0.\nUpgrade to libpgtypes2_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'libpq-dev', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq-dev is vulnerable in Debian 4.0.\nUpgrade to libpq-dev_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'libpq4', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq4 is vulnerable in Debian 4.0.\nUpgrade to libpq4_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-client-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-client-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-contrib-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-contrib-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-doc-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-doc-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plperl-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plperl-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plperl-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plpython-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plpython-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plpython-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-pltcl-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-pltcl-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-pltcl-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-server-dev-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-server-dev-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-server-dev-8.1_8.1.9-0etch1\n');
}
if (deb_check(prefix: 'postgresql-8.1', release: '4.0', reference: '8.1.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-8.1 is vulnerable in Debian etch.\nUpgrade to postgresql-8.1_8.1.9-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
