# This script was automatically generated from the dsa-1314
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local and remote vulnerabilities have been discovered in
open-iscsi, a transport-independent iSCSI implementation. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Olaf Kirch discovered that due to a programming error access to the
    management interface socket was insufficiently protected, which allows
    denial of service.
    Olaf Kirch discovered that access to a semaphore used in the logging
    code was insufficiently protected, allowing denial of service.
The oldstable distribution (sarge) doesn\'t include open-iscsi.
For the stable distribution (etch) these problems have been fixed
in version 2.0.730-1etch1.
For the unstable distribution (sid) these problems have been fixed in
version 2.0.865-1.
We recommend that you upgrade your open-iscsi packages.


Solution : http://www.debian.org/security/2007/dsa-1314
Risk factor : High';

if (description) {
 script_id(25558);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1314");
 script_cve_id("CVE-2007-3099", "CVE-2007-3100");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1314] DSA-1314-1 open-iscsi");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1314-1 open-iscsi");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'open-iscsi', release: '4.0', reference: '2.0.730-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package open-iscsi is vulnerable in Debian 4.0.\nUpgrade to open-iscsi_2.0.730-1etch1\n');
}
if (deb_check(prefix: 'open-iscsi', release: '4.0', reference: '2.0.730-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package open-iscsi is vulnerable in Debian etch.\nUpgrade to open-iscsi_2.0.730-1etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
