# This script was automatically generated from the dsa-1321
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the IMAP code in the Evolution Data Server
performs insufficient sanitising of a value later used an array index,
which can lead to the execution of arbitrary code.
For the oldstable distribution (sarge) a different source package
is affected and will be fixed separately.
For the stable distribution (etch) this problem has been fixed in
version 1.6.3-5etch1.
For the unstable distribution (sid) this problem has been fixed in
version 1.10.2-2.
We recommend that you upgrade your evolution-data-server packages.


Solution : http://www.debian.org/security/2007/dsa-1321
Risk factor : High';

if (description) {
 script_id(25615);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1321");
 script_cve_id("CVE-2007-3257");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1321] DSA-1321-1 evolution-data-server");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1321-1 evolution-data-server");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'evolution-data-server', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-data-server is vulnerable in Debian 4.0.\nUpgrade to evolution-data-server_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'evolution-data-server-common', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-data-server-common is vulnerable in Debian 4.0.\nUpgrade to evolution-data-server-common_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'evolution-data-server-dbg', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-data-server-dbg is vulnerable in Debian 4.0.\nUpgrade to evolution-data-server-dbg_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'evolution-data-server-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-data-server-dev is vulnerable in Debian 4.0.\nUpgrade to evolution-data-server-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libcamel1.2-8', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libcamel1.2-8 is vulnerable in Debian 4.0.\nUpgrade to libcamel1.2-8_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libcamel1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libcamel1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libcamel1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libebook1.2-5', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libebook1.2-5 is vulnerable in Debian 4.0.\nUpgrade to libebook1.2-5_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libebook1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libebook1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libebook1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libecal1.2-6', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecal1.2-6 is vulnerable in Debian 4.0.\nUpgrade to libecal1.2-6_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libecal1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecal1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libecal1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedata-book1.2-2', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedata-book1.2-2 is vulnerable in Debian 4.0.\nUpgrade to libedata-book1.2-2_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedata-book1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedata-book1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libedata-book1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedata-cal1.2-5', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedata-cal1.2-5 is vulnerable in Debian 4.0.\nUpgrade to libedata-cal1.2-5_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedata-cal1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedata-cal1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libedata-cal1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedataserver1.2-7', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedataserver1.2-7 is vulnerable in Debian 4.0.\nUpgrade to libedataserver1.2-7_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedataserver1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedataserver1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libedataserver1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedataserverui1.2-6', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedataserverui1.2-6 is vulnerable in Debian 4.0.\nUpgrade to libedataserverui1.2-6_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libedataserverui1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libedataserverui1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libedataserverui1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libegroupwise1.2-10', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libegroupwise1.2-10 is vulnerable in Debian 4.0.\nUpgrade to libegroupwise1.2-10_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libegroupwise1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libegroupwise1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libegroupwise1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libexchange-storage1.2-1', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexchange-storage1.2-1 is vulnerable in Debian 4.0.\nUpgrade to libexchange-storage1.2-1_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'libexchange-storage1.2-dev', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexchange-storage1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libexchange-storage1.2-dev_1.6.3-5etch1\n');
}
if (deb_check(prefix: 'evolution-data-server', release: '4.0', reference: '1.6.3-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-data-server is vulnerable in Debian etch.\nUpgrade to evolution-data-server_1.6.3-5etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
