# This script was automatically generated from the dsa-1325
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Evolution, a
groupware suite with mail client and organizer. The Common Vulnerabilities
and Exposures project identifies the following problems:
    Ulf Hrnhammar discovered that a format string vulnerability in
    the handling of shared calendars may allow the execution of arbitrary
    code.
    It was discovered that the IMAP code in the Evolution Data Server
    performs insufficient sanitising of a value later used an array index,
    which can lead to the execution of arbitrary code.
For the oldstable distribution (sarge) these problems have been fixed in
version 2.0.4-2sarge2. Packages for hppa, mips and powerpc are not yet
available. They will be provided later.
For the stable distribution (etch) these problems have been fixed
in version 2.6.3-6etch1. Packages for mips are not yet available. They
will be provided later.
For the unstable distribution (sid) these problems will be fixed soon.
We recommend that you upgrade your evolution packages.


Solution : http://www.debian.org/security/2007/dsa-1325
Risk factor : High';

if (description) {
 script_id(25675);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1325");
 script_cve_id("CVE-2007-1002", "CVE-2007-3257");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1325] DSA-1325-1 evolution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1325-1 evolution");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'evolution', release: '3.1', reference: '2.0.4-2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian 3.1.\nUpgrade to evolution_2.0.4-2sarge2\n');
}
if (deb_check(prefix: 'evolution-dev', release: '3.1', reference: '2.0.4-2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dev is vulnerable in Debian 3.1.\nUpgrade to evolution-dev_2.0.4-2sarge2\n');
}
if (deb_check(prefix: 'evolution', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian 4.0.\nUpgrade to evolution_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution-common', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-common is vulnerable in Debian 4.0.\nUpgrade to evolution-common_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution-dbg', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dbg is vulnerable in Debian 4.0.\nUpgrade to evolution-dbg_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution-dev', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dev is vulnerable in Debian 4.0.\nUpgrade to evolution-dev_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution-plugins', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-plugins is vulnerable in Debian 4.0.\nUpgrade to evolution-plugins_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution-plugins-experimental', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-plugins-experimental is vulnerable in Debian 4.0.\nUpgrade to evolution-plugins-experimental_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution', release: '4.0', reference: '2.6.3-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian etch.\nUpgrade to evolution_2.6.3-6etch1\n');
}
if (deb_check(prefix: 'evolution', release: '3.1', reference: '2.0.4-2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian sarge.\nUpgrade to evolution_2.0.4-2sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
