# This script was automatically generated from the dsa-1335
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Gimp, the GNU Image
Manipulation Program, which might lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:
    Sean Larsson discovered several integer overflows in the processing
    code for DICOM, PNM, PSD, RAS, XBM and XWD images, which might lead
    to the execution of arbitrary code if a user is tricked into opening
    such a malformed media file.
    Stefan Cornelius discovered an integer overflow in the processing
    code for PSD images, which might lead to the execution of arbitrary
    code if a user is tricked into opening such a malformed media file.
For the oldstable distribution (sarge) these problems have been fixed in
version 2.2.6-1sarge4. Packages for mips and mipsel are not yet
available.
For the stable distribution (etch) these problems have been fixed
in version 2.2.13-1etch4. Packages for mips are not yet available.
For the unstable distribution (sid) these problems have been fixed in
version 2.2.17-1.
We recommend that you upgrade your gimp packages.


Solution : http://www.debian.org/security/2007/dsa-1335
Risk factor : High';

if (description) {
 script_id(25744);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1335");
 script_cve_id("CVE-2006-4519", "CVE-2007-2949");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1335] DSA-1335-1 gimp");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1335-1 gimp");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gimp', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp is vulnerable in Debian 3.1.\nUpgrade to gimp_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp-data', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-data is vulnerable in Debian 3.1.\nUpgrade to gimp-data_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp-helpbrowser', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-helpbrowser is vulnerable in Debian 3.1.\nUpgrade to gimp-helpbrowser_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp-python', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-python is vulnerable in Debian 3.1.\nUpgrade to gimp-python_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp-svg', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-svg is vulnerable in Debian 3.1.\nUpgrade to gimp-svg_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp1.2', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp1.2 is vulnerable in Debian 3.1.\nUpgrade to gimp1.2_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'libgimp2.0', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0 is vulnerable in Debian 3.1.\nUpgrade to libgimp2.0_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'libgimp2.0-dev', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0-dev is vulnerable in Debian 3.1.\nUpgrade to libgimp2.0-dev_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'libgimp2.0-doc', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0-doc is vulnerable in Debian 3.1.\nUpgrade to libgimp2.0-doc_2.2.6-1sarge4\n');
}
if (deb_check(prefix: 'gimp', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp is vulnerable in Debian 4.0.\nUpgrade to gimp_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp-data', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-data is vulnerable in Debian 4.0.\nUpgrade to gimp-data_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp-dbg', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-dbg is vulnerable in Debian 4.0.\nUpgrade to gimp-dbg_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp-helpbrowser', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-helpbrowser is vulnerable in Debian 4.0.\nUpgrade to gimp-helpbrowser_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp-python', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-python is vulnerable in Debian 4.0.\nUpgrade to gimp-python_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp-svg', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp-svg is vulnerable in Debian 4.0.\nUpgrade to gimp-svg_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'libgimp2.0', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0 is vulnerable in Debian 4.0.\nUpgrade to libgimp2.0_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'libgimp2.0-dev', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0-dev is vulnerable in Debian 4.0.\nUpgrade to libgimp2.0-dev_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'libgimp2.0-doc', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgimp2.0-doc is vulnerable in Debian 4.0.\nUpgrade to libgimp2.0-doc_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp', release: '4.0', reference: '2.2.13-1etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp is vulnerable in Debian etch.\nUpgrade to gimp_2.2.13-1etch4\n');
}
if (deb_check(prefix: 'gimp', release: '3.1', reference: '2.2.6-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gimp is vulnerable in Debian sarge.\nUpgrade to gimp_2.2.6-1sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
