# This script was automatically generated from the dsa-1337
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:
    Ronen Zilberman and Michal Zalewski discovered that a timing race
    allows the injection of content into about:blank frames.
    Michal Zalewski discovered that same-origin policies for wyciwyg://
    documents are insufficiently enforced.
    Bernd Mielke, Boris Zbarsky, David Baron, Daniel Veditz, Jesse Ruderman,
    Lukas Loehrer, Martijn Wargers, Mats Palmgren, Olli Pettay, Paul
    Nickerson and Vladimir Sukhoy discovered crashes in the layout engine,
    which might allow the execution of arbitrary code.
    Asaf Romano, Jesse Ruderman and Igor Bukanov discovered crashes in the
    javascript engine, which might allow the execution of arbitrary code.
    <q>moz_bug_r_a4</q> discovered that the addEventListener() and setTimeout()
    functions allow cross-site scripting.
    <q>moz_bug_r_a4</q> discovered that a programming error in event handling
    allows privilege escalation.
    <q>shutdown</q> and <q>moz_bug_r_a4</q> discovered that the XPCNativeWrapper allows
    the execution of arbitrary code.
The oldstable distribution (sarge) doesn\'t include xulrunner.
For the stable distribution (etch) these problems have been fixed in version
1.8.0.13~pre070720-0etch1. A build for the mips architecture is not yet
available, it will be provided later.
For the unstable distribution (sid) these problems have been fixed in version
1.8.1.5-1.
We recommend that you upgrade your xulrunner packages.


Solution : http://www.debian.org/security/2007/dsa-1337
Risk factor : High';

if (description) {
 script_id(25780);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1337");
 script_cve_id("CVE-2007-3089", "CVE-2007-3285", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1337] DSA-1337-1 xulrunner");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1337-1 xulrunner");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libmozjs0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozjs0d is vulnerable in Debian 4.0.\nUpgrade to libmozjs0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libmozjs0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozjs0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libmozjs0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnspr4-0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnspr4-0d is vulnerable in Debian 4.0.\nUpgrade to libnspr4-0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnspr4-0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnspr4-0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libnspr4-0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-0d is vulnerable in Debian 4.0.\nUpgrade to libnss3-0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libnss3-0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-tools', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-tools is vulnerable in Debian 4.0.\nUpgrade to libnss3-tools_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul0d is vulnerable in Debian 4.0.\nUpgrade to libxul0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libxul0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'python-xpcom', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-xpcom is vulnerable in Debian 4.0.\nUpgrade to python-xpcom_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'spidermonkey-bin', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package spidermonkey-bin is vulnerable in Debian 4.0.\nUpgrade to spidermonkey-bin_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian 4.0.\nUpgrade to xulrunner_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner-gnome-support', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner-gnome-support is vulnerable in Debian 4.0.\nUpgrade to xulrunner-gnome-support_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian etch.\nUpgrade to xulrunner_1.8.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
