# This script was automatically generated from the dsa-1341
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
This update provides fixed packages for the oldstable distribution (sarge).
For reference the original advisory text:
Amit Klein discovered that the BIND name server generates predictable 
DNS query IDs, which may lead to cache poisoning attacks.
For the oldstable distribution (sarge) this problem has been fixed in
version 9.2.4-1sarge3. An update for mips, powerpc and hppa is not yet
available, they will be released soon.
For the stable distribution (etch) this problem has been fixed in
version 9.3.4-2etch1. An update for mips is not yet available, it will
be released soon.
For the unstable distribution (sid) this problem will be fixed soon.
We recommend that you upgrade your BIND packages.


Solution : http://www.debian.org/security/2007/dsa-1341
Risk factor : High';

if (description) {
 script_id(25851);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1341");
 script_cve_id("CVE-2007-2926");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1341] DSA-1341-2 bind9");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1341-2 bind9");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'bind9', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9 is vulnerable in Debian 3.1.\nUpgrade to bind9_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'bind9-doc', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9-doc is vulnerable in Debian 3.1.\nUpgrade to bind9-doc_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'bind9-host', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9-host is vulnerable in Debian 3.1.\nUpgrade to bind9-host_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'dnsutils', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dnsutils is vulnerable in Debian 3.1.\nUpgrade to dnsutils_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'libbind-dev', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libbind-dev is vulnerable in Debian 3.1.\nUpgrade to libbind-dev_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'libdns16', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdns16 is vulnerable in Debian 3.1.\nUpgrade to libdns16_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'libisc7', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisc7 is vulnerable in Debian 3.1.\nUpgrade to libisc7_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'libisccc0', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisccc0 is vulnerable in Debian 3.1.\nUpgrade to libisccc0_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'libisccfg0', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisccfg0 is vulnerable in Debian 3.1.\nUpgrade to libisccfg0_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'liblwres1', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package liblwres1 is vulnerable in Debian 3.1.\nUpgrade to liblwres1_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'lwresd', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lwresd is vulnerable in Debian 3.1.\nUpgrade to lwresd_9.2.4-1sarge3\n');
}
if (deb_check(prefix: 'bind9', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9 is vulnerable in Debian 4.0.\nUpgrade to bind9_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'bind9-doc', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9-doc is vulnerable in Debian 4.0.\nUpgrade to bind9-doc_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'bind9-host', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9-host is vulnerable in Debian 4.0.\nUpgrade to bind9-host_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'dnsutils', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dnsutils is vulnerable in Debian 4.0.\nUpgrade to dnsutils_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libbind-dev', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libbind-dev is vulnerable in Debian 4.0.\nUpgrade to libbind-dev_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libbind9-0', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libbind9-0 is vulnerable in Debian 4.0.\nUpgrade to libbind9-0_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libdns22', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdns22 is vulnerable in Debian 4.0.\nUpgrade to libdns22_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libisc11', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisc11 is vulnerable in Debian 4.0.\nUpgrade to libisc11_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libisccc0', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisccc0 is vulnerable in Debian 4.0.\nUpgrade to libisccc0_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'libisccfg1', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libisccfg1 is vulnerable in Debian 4.0.\nUpgrade to libisccfg1_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'liblwres9', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package liblwres9 is vulnerable in Debian 4.0.\nUpgrade to liblwres9_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'lwresd', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lwresd is vulnerable in Debian 4.0.\nUpgrade to lwresd_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'bind9', release: '4.0', reference: '9.3.4-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9 is vulnerable in Debian etch.\nUpgrade to bind9_9.3.4-2etch1\n');
}
if (deb_check(prefix: 'bind9', release: '3.1', reference: '9.2.4-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bind9 is vulnerable in Debian sarge.\nUpgrade to bind9_9.2.4-1sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
