# This script was automatically generated from the dsa-1345
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:
    <q>moz_bug_r_a4</q> discovered that a regression in the handling of
    <q>about:blank</q> windows used by addons may lead to an attacker being
    able to modify the content of web sites.
    Jesper Johansson discovered that missing sanitising of double-quotes
    and spaces in URIs passed to external programs may allow an attacker
    to pass arbitrary arguments to the helper program if the user is
    tricked into opening a malformed web page.
The oldstable distribution (sarge) doesn\'t include xulrunner.
For the stable distribution (etch) these problems have been fixed in version
1.8.0.13~pre070720-0etch3.
For the unstable distribution (sid) these problems have been fixed in version
1.8.1.6-1.
We recommend that you upgrade your xulrunner packages.


Solution : http://www.debian.org/security/2007/dsa-1345
Risk factor : High';

if (description) {
 script_id(25853);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1345");
 script_cve_id("CVE-2007-3844", "CVE-2007-3845");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1345] DSA-1345-1 xulrunner");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1345-1 xulrunner");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian etch.\nUpgrade to xulrunner_1.8.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
