# This script was automatically generated from the dsa-1347
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that an integer overflow in the xpdf PDF viewer may lead
to the execution of arbitrary code if a malformed PDF file is opened.
For the oldstable distribution (sarge) this problem has been fixed in
version 3.00-13.7.
For the stable distribution (etch) this problem has been fixed in
version 3.01-9etch1.
For the unstable distribution (sid) this problem will be fixed soon.
We recommend that you upgrade your xpdf packages.


Solution : http://www.debian.org/security/2007/dsa-1347
Risk factor : High';

if (description) {
 script_id(25855);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1347");
 script_cve_id("CVE-2007-3387");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1347] DSA-1347-1 xpdf");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1347-1 xpdf");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xpdf', release: '3.1', reference: '3.00-13.7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf is vulnerable in Debian 3.1.\nUpgrade to xpdf_3.00-13.7\n');
}
if (deb_check(prefix: 'xpdf-common', release: '3.1', reference: '3.00-13.7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-common is vulnerable in Debian 3.1.\nUpgrade to xpdf-common_3.00-13.7\n');
}
if (deb_check(prefix: 'xpdf-reader', release: '3.1', reference: '3.00-13.7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-reader is vulnerable in Debian 3.1.\nUpgrade to xpdf-reader_3.00-13.7\n');
}
if (deb_check(prefix: 'xpdf-utils', release: '3.1', reference: '3.00-13.7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-utils is vulnerable in Debian 3.1.\nUpgrade to xpdf-utils_3.00-13.7\n');
}
if (deb_check(prefix: 'xpdf', release: '4.0', reference: '3.01-9etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf is vulnerable in Debian 4.0.\nUpgrade to xpdf_3.01-9etch1\n');
}
if (deb_check(prefix: 'xpdf-common', release: '4.0', reference: '3.01-9etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-common is vulnerable in Debian 4.0.\nUpgrade to xpdf-common_3.01-9etch1\n');
}
if (deb_check(prefix: 'xpdf-reader', release: '4.0', reference: '3.01-9etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-reader is vulnerable in Debian 4.0.\nUpgrade to xpdf-reader_3.01-9etch1\n');
}
if (deb_check(prefix: 'xpdf-utils', release: '4.0', reference: '3.01-9etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf-utils is vulnerable in Debian 4.0.\nUpgrade to xpdf-utils_3.01-9etch1\n');
}
if (deb_check(prefix: 'xpdf', release: '4.0', reference: '3.01-9etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf is vulnerable in Debian etch.\nUpgrade to xpdf_3.01-9etch1\n');
}
if (deb_check(prefix: 'xpdf', release: '3.1', reference: '3.00-13.7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xpdf is vulnerable in Debian sarge.\nUpgrade to xpdf_3.00-13.7\n');
}
if (w) { security_hole(port: 0, data: desc); }
