# This script was automatically generated from the dsa-1358
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Asterisk, a free
software PBX and telephony toolkit. The Common Vulnerabilities and
Exposures project identifies the following problems:
    <q>Mu Security</q> discovered that a NULL pointer dereference in the SIP
    implementation could lead to denial of service.
    Inria Lorraine discovered that a programming error in the SIP
    implementation could lead to denial of service.
    It was discovered that a NULL pointer dereference in the manager
    interface could lead to denial of service.
    It was discovered that a programming error in the SIP implementation
    could lead to denial of service.
    Tim Panton and Birgit Arkestein discovered that a programming error
    in the IAX2 implementation could lead to information disclosure.
    Russell Bryant discovered that a buffer overflow in the IAX
    implementation could lead to the execution of arbitrary code.
    Chris Clark and Zane Lackey discovered that several NULL pointer
    dereferences in the IAX2 implementation could lead to denial of
    service.
    Will Drewry discovered that a programming error in the Skinny
    implementation could lead to denial of service.
For the oldstable distribution (sarge) these problems have been fixed in
version 1.0.7.dfsg.1-2sarge5.
For the stable distribution (etch) these problems have been fixed
in version 1:1.2.13~dfsg-2etch1.
For the unstable distribution (sid) these problems have been fixed in
version 1:1.4.11~dfsg-1.
We recommend that you upgrade your Asterisk packages.


Solution : http://www.debian.org/security/2007/dsa-1358
Risk factor : High';

if (description) {
 script_id(25938);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1358");
 script_cve_id("CVE-2007-1306", "CVE-2007-1561", "CVE-2007-2294", "CVE-2007-2297", "CVE-2007-2488", "CVE-2007-3762", "CVE-2007-3763");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1358] DSA-1358-1 asterisk");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1358-1 asterisk");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'asterisk', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian 3.1.\nUpgrade to asterisk_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-config', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-config is vulnerable in Debian 3.1.\nUpgrade to asterisk-config_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-dev', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-dev is vulnerable in Debian 3.1.\nUpgrade to asterisk-dev_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-doc', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-doc is vulnerable in Debian 3.1.\nUpgrade to asterisk-doc_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-gtk-console', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-gtk-console is vulnerable in Debian 3.1.\nUpgrade to asterisk-gtk-console_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-h323', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-h323 is vulnerable in Debian 3.1.\nUpgrade to asterisk-h323_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-sounds-main', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-sounds-main is vulnerable in Debian 3.1.\nUpgrade to asterisk-sounds-main_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk-web-vmail', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-web-vmail is vulnerable in Debian 3.1.\nUpgrade to asterisk-web-vmail_1.0.7.dfsg.1-2sarge5\n');
}
if (deb_check(prefix: 'asterisk', release: '4.0', reference: '1.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian etch.\nUpgrade to asterisk_1.2\n');
}
if (deb_check(prefix: 'asterisk', release: '3.1', reference: '1.0.7.dfsg.1-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian sarge.\nUpgrade to asterisk_1.0.7.dfsg.1-2sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
