# This script was automatically generated from the dsa-1367
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that a buffer overflow of the RPC library of the MIT
Kerberos reference implementation allows the execution of arbitrary code.
The oldstable distribution (sarge) is not affected by this problem.
For the stable distribution (etch) this problem has been fixed in
version 1.4.4-7etch3.
For the unstable distribution (sid) this problem has been fixed in
version 1.6.dfsg.1-7.
We recommend that you upgrade your Kerberos packages.


Solution : http://www.debian.org/security/2007/dsa-1367
Risk factor : High';

if (description) {
 script_id(25974);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1367");
 script_cve_id("CVE-2007-3999");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1367] DSA-1367-1 krb5");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1367-1 krb5");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'krb5-admin-server', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-admin-server is vulnerable in Debian 4.0.\nUpgrade to krb5-admin-server_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-clients', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-clients is vulnerable in Debian 4.0.\nUpgrade to krb5-clients_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-doc', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-doc is vulnerable in Debian 4.0.\nUpgrade to krb5-doc_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-ftpd', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-ftpd is vulnerable in Debian 4.0.\nUpgrade to krb5-ftpd_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-kdc', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-kdc is vulnerable in Debian 4.0.\nUpgrade to krb5-kdc_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-rsh-server', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-rsh-server is vulnerable in Debian 4.0.\nUpgrade to krb5-rsh-server_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-telnetd', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-telnetd is vulnerable in Debian 4.0.\nUpgrade to krb5-telnetd_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5-user', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-user is vulnerable in Debian 4.0.\nUpgrade to krb5-user_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'libkadm55', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkadm55 is vulnerable in Debian 4.0.\nUpgrade to libkadm55_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'libkrb5-dbg', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dbg is vulnerable in Debian 4.0.\nUpgrade to libkrb5-dbg_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'libkrb5-dev', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dev is vulnerable in Debian 4.0.\nUpgrade to libkrb5-dev_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'libkrb53', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb53 is vulnerable in Debian 4.0.\nUpgrade to libkrb53_1.4.4-7etch3\n');
}
if (deb_check(prefix: 'krb5', release: '4.0', reference: '1.4.4-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5 is vulnerable in Debian etch.\nUpgrade to krb5_1.4.4-7etch3\n');
}
if (w) { security_hole(port: 0, data: desc); }
