# This script was automatically generated from the dsa-1386
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A problem has been discovered in the processing of chat messages.
Overly long messages are truncated by the server to a fixed length,
without paying attention to the multibyte characters.  This leads to
invalid UTF-8 on clients and causes an uncaught exception.  Note that
both wesnoth and the wesnoth server are affected.
For the old stable distribution (sarge) this problem has been fixed in
version 0.9.0-6 and in version 1.2.7-1~bpo31+1 of sarge-backports.
For the stable distribution (etch) this problem has been fixed in
version 1.2-2 and in version 1.2.7-1~bpo40+1 of etch-backports.
For the unstable distribution (sid) this problem has been fixed in
version 1.2.7-1.
Packages for the oldstable mips architecture will be added to the
archive later.
We recommend that you upgrade your wesnoth packages.


Solution : http://www.debian.org/security/2007/dsa-1386
Risk factor : High';

if (description) {
 script_id(27043);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1386");
 script_cve_id("CVE-2007-3917");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1386] DSA-1386-1 wesnoth");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1386-1 wesnoth");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'wesnoth', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth is vulnerable in Debian 3.1.\nUpgrade to wesnoth_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-data', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-data is vulnerable in Debian 3.1.\nUpgrade to wesnoth-data_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-editor', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-editor is vulnerable in Debian 3.1.\nUpgrade to wesnoth-editor_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-ei', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-ei is vulnerable in Debian 3.1.\nUpgrade to wesnoth-ei_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-httt', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-httt is vulnerable in Debian 3.1.\nUpgrade to wesnoth-httt_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-music', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-music is vulnerable in Debian 3.1.\nUpgrade to wesnoth-music_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-server', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-server is vulnerable in Debian 3.1.\nUpgrade to wesnoth-server_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-sotbe', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-sotbe is vulnerable in Debian 3.1.\nUpgrade to wesnoth-sotbe_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-tdh', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-tdh is vulnerable in Debian 3.1.\nUpgrade to wesnoth-tdh_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth-trow', release: '3.1', reference: '0.9.0-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-trow is vulnerable in Debian 3.1.\nUpgrade to wesnoth-trow_0.9.0-6\n');
}
if (deb_check(prefix: 'wesnoth', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth is vulnerable in Debian 4.0.\nUpgrade to wesnoth_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-data', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-data is vulnerable in Debian 4.0.\nUpgrade to wesnoth-data_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-editor', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-editor is vulnerable in Debian 4.0.\nUpgrade to wesnoth-editor_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-ei', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-ei is vulnerable in Debian 4.0.\nUpgrade to wesnoth-ei_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-httt', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-httt is vulnerable in Debian 4.0.\nUpgrade to wesnoth-httt_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-music', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-music is vulnerable in Debian 4.0.\nUpgrade to wesnoth-music_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-server', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-server is vulnerable in Debian 4.0.\nUpgrade to wesnoth-server_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-trow', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-trow is vulnerable in Debian 4.0.\nUpgrade to wesnoth-trow_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-tsg', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-tsg is vulnerable in Debian 4.0.\nUpgrade to wesnoth-tsg_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-ttb', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-ttb is vulnerable in Debian 4.0.\nUpgrade to wesnoth-ttb_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth-utbs', release: '4.0', reference: '1.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth-utbs is vulnerable in Debian 4.0.\nUpgrade to wesnoth-utbs_1.2-2\n');
}
if (deb_check(prefix: 'wesnoth', release: '4.0', reference: '1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth is vulnerable in Debian etch.\nUpgrade to wesnoth_1\n');
}
if (deb_check(prefix: 'wesnoth', release: '3.1', reference: '0.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wesnoth is vulnerable in Debian sarge.\nUpgrade to wesnoth_0.9\n');
}
if (w) { security_hole(port: 0, data: desc); }
