# This script was automatically generated from the dsa-1390
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Hamid Ebadi discovered a buffer overflow in the
intT1_Env_GetCompletePath routine in t1lib, a Type 1 font rasterizer
library.  This flaw could allow an attacker to crash an application
using the t1lib shared libraries, and potentially execute arbitrary code
within such an application\'s security context.
For the old stable distribution (sarge), this problem has been fixed in
version 5.0.2-3sarge1.
For the stable distribution (etch), this problem has been fixed in
version 5.1.0-2etch1.
We recommend that you upgrade your t1lib package.


Solution : http://www.debian.org/security/2007/dsa-1390
Risk factor : High';

if (description) {
 script_id(27545);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1390");
 script_cve_id("CVE-2007-4033");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1390] DSA-1390-1 t1lib");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1390-1 t1lib");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libt1-5', release: '3.1', reference: '5.1.0-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libt1-5 is vulnerable in Debian 3.1.\nUpgrade to libt1-5_5.1.0-2etch1\n');
}
if (deb_check(prefix: 'libt1-dev', release: '3.1', reference: '5.1.0-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libt1-dev is vulnerable in Debian 3.1.\nUpgrade to libt1-dev_5.1.0-2etch1\n');
}
if (deb_check(prefix: 'libt1-doc', release: '3.1', reference: '5.1.0-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libt1-doc is vulnerable in Debian 3.1.\nUpgrade to libt1-doc_5.1.0-2etch1\n');
}
if (deb_check(prefix: 't1lib-bin', release: '3.1', reference: '5.1.0-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package t1lib-bin is vulnerable in Debian 3.1.\nUpgrade to t1lib-bin_5.1.0-2etch1\n');
}
if (deb_check(prefix: 't1lib', release: '4.0', reference: '5.1.0-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package t1lib is vulnerable in Debian etch.\nUpgrade to t1lib_5.1.0-2etch1\n');
}
if (deb_check(prefix: 't1lib', release: '3.1', reference: '5.0.2-3sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package t1lib is vulnerable in Debian sarge.\nUpgrade to t1lib_5.0.2-3sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
