# This script was automatically generated from the dsa-1392
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:
    Michal Zalewski discovered that the unload event handler had access to
    the address of the next page to be loaded, which could allow information
    disclosure or spoofing.
    Stefano Di Paola discovered that insufficient validation of user names
    used in Digest authentication on a web site allows HTTP response splitting
    attacks.
    It was discovered that insecure focus handling of the file upload
    control can lead to information disclosure. This is a variant of
    CVE-2006-2894.
    Eli Friedman discovered that web pages written in Xul markup can hide the
    titlebar of windows, which can lead to spoofing attacks.
    Georgi Guninski discovered the insecure handling of smb:// and sftp:// URI
    schemes may lead to information disclosure. This vulnerability is only
    exploitable if Gnome-VFS support is present on the system.
    <q>moz_bug_r_a4</q> discovered that the protection scheme offered by XPCNativeWrappers
    could be bypassed, which might allow privilege escalation.
    L. David Baron, Boris Zbarsky, Georgi Guninski, Paul Nickerson, Olli Pettay,
    Jesse Ruderman, Vladimir Sukhoy, Daniel Veditz, and Martijn Wargers discovered
    crashes in the layout engine, which might allow the execution of arbitrary code.
    Igor Bukanov, Eli Friedman, and Jesse Ruderman discovered crashes in the
    Javascript engine, which might allow the execution of arbitrary code.
The oldstable distribution (sarge) doesn\'t contain xulrunner.
For the stable distribution (etch) these problems have been fixed in version
1.8.0.14~pre071019b-0etch1. Builds for hppa and mipsel will be provided later.
For the unstable distribution (sid) these problems will be fixed soon.
We recommend that you upgrade your xulrunner packages.


Solution : http://www.debian.org/security/2007/dsa-1392
Risk factor : High';

if (description) {
 script_id(27547);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1392");
 script_cve_id("CVE-2007-1095", "CVE-2007-2292", "CVE-2007-3511", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5338", "CVE-2007-5339");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1392] DSA-1392-1 xulrunner");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1392-1 xulrunner");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian etch.\nUpgrade to xulrunner_1.8.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
