# This script was automatically generated from the dsa-1394
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that reprepro, a tool to create a repository of Debian
packages, only checks the validity of known signatures when updating
from a remote site, and thus does not reject packages with only unknown
signatures. This allows an attacker to bypass this authentication
mechanism.
The oldstable distribution (sarge) is not affected by this problem.
For the stable distribution (etch) this problem has been fixed in
version 1.3.1+1-1.
For the unstable distribution (sid) this problem has been fixed in
version 2.2.4-1.
We recommend that you upgrade your reprepro package.


Solution : http://www.debian.org/security/2007/dsa-1394
Risk factor : High';

if (description) {
 script_id(27549);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1394");
 script_cve_id("CVE-2007-4739");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1394] DSA-1394-1 reprepro");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1394-1 reprepro");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'reprepro', release: '4.0', reference: '1.3.1+1-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package reprepro is vulnerable in Debian 4.0.\nUpgrade to reprepro_1.3.1+1-1\n');
}
if (deb_check(prefix: 'reprepro', release: '4.0', reference: '1.3.1+1-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package reprepro is vulnerable in Debian etch.\nUpgrade to reprepro_1.3.1+1-1\n');
}
if (w) { security_hole(port: 0, data: desc); }
