# This script was automatically generated from the dsa-1395
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Steve Kemp from the Debian Security Audit project discovered that xen-utils,
a collection of XEN administrative tools, used temporary files insecurely
within the xenmon tool allowing local users to truncate arbitrary files.
For the old stable distribution (sarge) this package was not present.
For the stable distribution (etch) this problem has been fixed in version
3.0.3-0-4.
For the unstable distribution (sid) this problem will be fixed soon.
We recommend that you upgrade your xen-3.0 package.


Solution : http://www.debian.org/security/2007/dsa-1395
Risk factor : High';

if (description) {
 script_id(27577);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1395");
 script_cve_id("CVE-2007-3919");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1395] DSA-1395-1 xen-utils");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1395-1 xen-utils");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xen-docs-3.0', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-docs-3.0 is vulnerable in Debian 4.0.\nUpgrade to xen-docs-3.0_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-amd64', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-amd64_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-i386', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-i386 is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-i386_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-i386-pae', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-i386-pae is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-i386-pae_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-ioemu-3.0.3-1', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-ioemu-3.0.3-1 is vulnerable in Debian 4.0.\nUpgrade to xen-ioemu-3.0.3-1_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-utils-3.0.3-1', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-utils-3.0.3-1 is vulnerable in Debian 4.0.\nUpgrade to xen-utils-3.0.3-1_3.0.3-0-4\n');
}
if (deb_check(prefix: 'xen-utils', release: '4.0', reference: '3.0.3-0-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-utils is vulnerable in Debian etch.\nUpgrade to xen-utils_3.0.3-0-4\n');
}
if (w) { security_hole(port: 0, data: desc); }
