# This script was automatically generated from the dsa-1400
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Will Drewry and Tavis Ormandy of the Google Security Team have
discovered a UTF-8 related heap overflow in Perl\'s regular expression
compiler, probably allowing attackers to execute arbitrary code by
compiling specially crafted regular expressions.


For the stable distribution (etch), this problem has been fixed in
version 5.8.8-7etch1.


For the old stable distribution (sarge), this problem has been fixed in
version 5.8.4-8sarge6.


For the unstable distribution (sid), this problem will be fixed soon.


Some architectures are missing from this DSA; these updates will be
released once they are available.


We recommend that you upgrade your perl package.



Solution : http://www.debian.org/security/2007/dsa-1400
Risk factor : High';

if (description) {
 script_id(27804);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1400");
 script_cve_id("CVE-2007-5116");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1400] DSA-1400-1 perl");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1400-1 perl");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libcgi-fast-perl', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libcgi-fast-perl is vulnerable in Debian 3.1.\nUpgrade to libcgi-fast-perl_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'libperl-dev', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libperl-dev is vulnerable in Debian 3.1.\nUpgrade to libperl-dev_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'libperl5.8', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libperl5.8 is vulnerable in Debian 3.1.\nUpgrade to libperl5.8_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl is vulnerable in Debian 3.1.\nUpgrade to perl_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl-base', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-base is vulnerable in Debian 3.1.\nUpgrade to perl-base_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl-debug', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-debug is vulnerable in Debian 3.1.\nUpgrade to perl-debug_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl-doc', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-doc is vulnerable in Debian 3.1.\nUpgrade to perl-doc_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl-modules', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-modules is vulnerable in Debian 3.1.\nUpgrade to perl-modules_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'perl-suid', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-suid is vulnerable in Debian 3.1.\nUpgrade to perl-suid_5.8.4-8sarge6\n');
}
if (deb_check(prefix: 'libcgi-fast-perl', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libcgi-fast-perl is vulnerable in Debian 4.0.\nUpgrade to libcgi-fast-perl_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'libperl-dev', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libperl-dev is vulnerable in Debian 4.0.\nUpgrade to libperl-dev_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'libperl5.8', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libperl5.8 is vulnerable in Debian 4.0.\nUpgrade to libperl5.8_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl is vulnerable in Debian 4.0.\nUpgrade to perl_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl-base', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-base is vulnerable in Debian 4.0.\nUpgrade to perl-base_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl-debug', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-debug is vulnerable in Debian 4.0.\nUpgrade to perl-debug_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl-doc', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-doc is vulnerable in Debian 4.0.\nUpgrade to perl-doc_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl-modules', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-modules is vulnerable in Debian 4.0.\nUpgrade to perl-modules_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl-suid', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl-suid is vulnerable in Debian 4.0.\nUpgrade to perl-suid_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl', release: '4.0', reference: '5.8.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl is vulnerable in Debian etch.\nUpgrade to perl_5.8.8-7etch1\n');
}
if (deb_check(prefix: 'perl', release: '3.1', reference: '5.8.4-8sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perl is vulnerable in Debian sarge.\nUpgrade to perl_5.8.4-8sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
