# This script was automatically generated from the dsa-1406
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several remote vulnerabilities have been discovered in the Horde web
application framework. The Common Vulnerabilities and Exposures project
identifies the following problems:

    
    Moritz Naumann discovered that Horde allows remote attackers
    to inject arbitrary web script or HTML in the context of a logged
    in user (cross site scripting).
    
    
    This vulnerability applies to oldstable (sarge) only.
    
    
    Moritz Naumann discovered that Horde does not properly restrict
    its image proxy, allowing remote attackers to use the server as a
    proxy.
    
    
    This vulnerability applies to oldstable (sarge) only.
    
    
    Marc Ruef discovered that Horde allows remote attackers to
    include web pages from other sites, which could be useful for
    phishing attacks.
    
    
    This vulnerability applies to oldstable (sarge) only.
    
    
    Moritz Naumann discovered that Horde allows remote attackers
    to inject arbitrary web script or HTML in the context of a logged
    in user (cross site scripting).
    
    
    This vulnerability applies to both stable (etch) and oldstable (sarge).
    
    
    iDefense discovered that the cleanup cron script in Horde
    allows local users to delete arbitrary files.
    
    
    This vulnerability applies to oldstable (sarge) only.
    

For the old stable distribution (sarge) these problems have been fixed in
version 3.0.4-4sarge6.


For the stable distribution (etch) these problems have been fixed in
version 3.1.3-4etch1.


For the unstable distribution (sid) these problems have been fixed in
version 3.1.4-1.


We recommend that you upgrade your horde3 package.



Solution : http://www.debian.org/security/2007/dsa-1406
Risk factor : High';

if (description) {
 script_id(28151);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1406");
 script_cve_id("CVE-2006-3548", "CVE-2006-3549", "CVE-2006-4256", "CVE-2007-1473", "CVE-2007-1474");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1406] DSA-1406-1 horde3");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1406-1 horde3");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'horde3', release: '3.1', reference: '3.0.4-4sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package horde3 is vulnerable in Debian 3.1.\nUpgrade to horde3_3.0.4-4sarge6\n');
}
if (deb_check(prefix: 'horde3', release: '4.0', reference: '3.1.3-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package horde3 is vulnerable in Debian 4.0.\nUpgrade to horde3_3.1.3-4etch1\n');
}
if (deb_check(prefix: 'horde3', release: '4.0', reference: '3.1.3-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package horde3 is vulnerable in Debian etch.\nUpgrade to horde3_3.1.3-4etch1\n');
}
if (deb_check(prefix: 'horde3', release: '3.1', reference: '3.0.4-4sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package horde3 is vulnerable in Debian sarge.\nUpgrade to horde3_3.0.4-4sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
