# This script was automatically generated from the dsa-1412
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in Ruby, an object-oriented
scripting language. The Common Vulnerabilities and Exposures project
identifies the following problems:
    It was discovered that the Ruby HTTP(S) module performs insufficient
    validation of SSL certificates, which may lead to man-in-the-middle
    attacks.
    It was discovered that the Ruby modules for FTP, Telnet, IMAP, POP
    and SMTP perform insufficient validation of SSL certificates, which
    may lead to man-in-the-middle attacks.
The old stable distribution (sarge) doesn\'t contain ruby1.9 packages.
For the stable distribution (etch) these problems have been fixed in
version 1.9.0+20060609-1etch1. Updated packages for hppa and sparc will
be provided later.
We recommend that you upgrade your ruby1.9 packages.


Solution : http://www.debian.org/security/2007/dsa-1412
Risk factor : High';

if (description) {
 script_id(28301);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1412");
 script_cve_id("CVE-2007-5162", "CVE-2007-5770");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1412] DSA-1412-1 ruby1.9");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1412-1 ruby1.9");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'irb1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package irb1.9 is vulnerable in Debian 4.0.\nUpgrade to irb1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libdbm-ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdbm-ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libdbm-ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libgdbm-ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgdbm-ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libgdbm-ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libopenssl-ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenssl-ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libopenssl-ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libreadline-ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libreadline-ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libreadline-ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libruby1.9-dbg', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libruby1.9-dbg is vulnerable in Debian 4.0.\nUpgrade to libruby1.9-dbg_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'libtcltk-ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libtcltk-ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to libtcltk-ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'rdoc1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package rdoc1.9 is vulnerable in Debian 4.0.\nUpgrade to rdoc1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ri1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ri1.9 is vulnerable in Debian 4.0.\nUpgrade to ri1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ruby1.9 is vulnerable in Debian 4.0.\nUpgrade to ruby1.9_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ruby1.9-dev', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ruby1.9-dev is vulnerable in Debian 4.0.\nUpgrade to ruby1.9-dev_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ruby1.9-elisp', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ruby1.9-elisp is vulnerable in Debian 4.0.\nUpgrade to ruby1.9-elisp_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ruby1.9-examples', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ruby1.9-examples is vulnerable in Debian 4.0.\nUpgrade to ruby1.9-examples_1.9.0+20060609-1etch1\n');
}
if (deb_check(prefix: 'ruby1.9', release: '4.0', reference: '1.9.0+20060609-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ruby1.9 is vulnerable in Debian etch.\nUpgrade to ruby1.9_1.9.0+20060609-1etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
