# This script was automatically generated from the dsa-1413
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several vulnerabilities have been found in the MySQL database packages
with implications ranging from unauthorized database modifications to
remotely triggered server crashes.
	The in_decimal::set function in item_cmpfunc.cc in MySQL
	before 5.0.40 allows context-dependent attackers to cause a
	denial of service (crash) via a crafted IF clause that results
	in a divide-by-zero error and a NULL pointer dereference.
	(Affects source version 5.0.32.)
	MySQL does not require the DROP privilege for RENAME TABLE
	statements, which allows remote authenticated users to rename
	arbitrary tables. (All supported versions affected.)
	The mysql_change_db function does not restore THD::db_access
	privileges when returning from SQL SECURITY INVOKER stored
	routines, which allows remote authenticated users to gain
	privileges.  (Affects source version 5.0.32.)
	MySQL could be made to overflow a signed char during
	authentication. Remote attackers could use specially crafted
	authentication requests to cause a denial of
	service. (Upstream source versions 4.1.11a and 5.0.32
	affected.)
	Phil Anderton discovered that MySQL did not properly verify
	access privileges when accessing external tables. As a result,
	authenticated users could exploit this to obtain UPDATE
	privileges to external tables.  (Affects source version
	5.0.32.)
	The convert_search_mode_to_innobase function in ha_innodb.cc
	in the InnoDB engine in MySQL 5.1.23-BK and earlier allows
	remote authenticated users to cause a denial of service
	(database crash) via a certain CONTAINS operation on an
	indexed column, which triggers an assertion error.  (Affects
	source version 5.0.32.)
For the old stable distribution (sarge), these problems have been fixed in
version 4.0.24-10sarge3 of mysql-dfsg and version 4.1.11a-4sarge8 of
mysql-dfsg-4.1.
For the stable distribution (etch), these problems have been fixed in
version 5.0.32-7etch3 of the mysql-dfsg-5.0 packages.
We recommend that you upgrade your mysql packages.


Solution : http://www.debian.org/security/2007/dsa-1413
Risk factor : High';

if (description) {
 script_id(28336);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1413");
 script_cve_id("CVE-2007-2583", "CVE-2007-2691", "CVE-2007-2692");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1413] DSA-1413-1 mysql");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1413-1 mysql");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libmysqlclient12', release: '3.1', reference: '4.0.24-10sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient12 is vulnerable in Debian 3.1.\nUpgrade to libmysqlclient12_4.0.24-10sarge3\n');
}
if (deb_check(prefix: 'libmysqlclient12-dev', release: '3.1', reference: '4.0.24-10sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient12-dev is vulnerable in Debian 3.1.\nUpgrade to libmysqlclient12-dev_4.0.24-10sarge3\n');
}
if (deb_check(prefix: 'libmysqlclient14', release: '3.1', reference: '4.1.11a-4sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient14 is vulnerable in Debian 3.1.\nUpgrade to libmysqlclient14_4.1.11a-4sarge8\n');
}
if (deb_check(prefix: 'libmysqlclient14-dev', release: '3.1', reference: '4.1.11a-4sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient14-dev is vulnerable in Debian 3.1.\nUpgrade to libmysqlclient14-dev_4.1.11a-4sarge8\n');
}
if (deb_check(prefix: 'mysql-client', release: '3.1', reference: '4.0.24-10sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client is vulnerable in Debian 3.1.\nUpgrade to mysql-client_4.0.24-10sarge3\n');
}
if (deb_check(prefix: 'mysql-client-4.1', release: '3.1', reference: '4.1.11a-4sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client-4.1 is vulnerable in Debian 3.1.\nUpgrade to mysql-client-4.1_4.1.11a-4sarge8\n');
}
if (deb_check(prefix: 'mysql-common', release: '3.1', reference: '4.0.24-10sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-common is vulnerable in Debian 3.1.\nUpgrade to mysql-common_4.0.24-10sarge3\n');
}
if (deb_check(prefix: 'mysql-common-4.1', release: '3.1', reference: '4.1.11a-4sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-common-4.1 is vulnerable in Debian 3.1.\nUpgrade to mysql-common-4.1_4.1.11a-4sarge8\n');
}
if (deb_check(prefix: 'mysql-server', release: '3.1', reference: '4.0.24-10sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server is vulnerable in Debian 3.1.\nUpgrade to mysql-server_4.0.24-10sarge3\n');
}
if (deb_check(prefix: 'mysql-server-4.1', release: '3.1', reference: '4.1.11a-4sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-4.1 is vulnerable in Debian 3.1.\nUpgrade to mysql-server-4.1_4.1.11a-4sarge8\n');
}
if (deb_check(prefix: 'libmysqlclient15-dev', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15-dev is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15-dev_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'libmysqlclient15off', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15off is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15off_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-client', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client is vulnerable in Debian 4.0.\nUpgrade to mysql-client_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-client-5.0', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-client-5.0_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-common', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-common is vulnerable in Debian 4.0.\nUpgrade to mysql-common_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-server', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server is vulnerable in Debian 4.0.\nUpgrade to mysql-server_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-server-4.1', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-4.1 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-4.1_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-server-5.0', release: '4.0', reference: '5.0.32-7etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-5.0_5.0.32-7etch3\n');
}
if (deb_check(prefix: 'mysql-dfsg,', release: '4.0', reference: '5.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-dfsg, is vulnerable in Debian etch.\nUpgrade to mysql-dfsg,_5.0\n');
}
if (deb_check(prefix: 'mysql-dfsg,', release: '3.1', reference: '4.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-dfsg, is vulnerable in Debian sarge.\nUpgrade to mysql-dfsg,_4.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
