# This script was automatically generated from the dsa-1414
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to denial of service or 
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:
    Stefan Esser discovered a buffer overflow in the SSL dissector.
    <q>Fabiodds</q> discovered a buffer overflow in the iSeries trace
    dissector.
    A programming error was discovered in the HTTP dissector, which may
    lead to denial of service.
    The MEGACO dissector could be tricked into resource exhaustion.
    The Bluetooth SDP dissector could be tricked into an endless loop.
    The RPC portmap dissector could be tricked into dereferencing
    a NULL pointer.
For the old stable distribution (sarge), these problems have been
fixed in version 0.10.10-2sarge10. (In Sarge Wireshark used to be
called Ethereal). Updated packages for sparc and m68k will be provided
later.
For the stable distribution (etch), these problems have been fixed
in version 0.99.4-5.etch.1. Updated packages for sparc will be provided
later.
We recommend that you upgrade your wireshark/ethereal packages.


Solution : http://www.debian.org/security/2007/dsa-1414
Risk factor : High';

if (description) {
 script_id(28337);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1414");
 script_cve_id("CVE-2007-6114", "CVE-2007-6117", "CVE-2007-6118", "CVE-2007-6120", "CVE-2007-6121");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1414] DSA-1414-1 wireshark");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1414-1 wireshark");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ethereal', release: '3.1', reference: '0.10.10-2sarge10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian 3.1.\nUpgrade to ethereal_0.10.10-2sarge10\n');
}
if (deb_check(prefix: 'ethereal-common', release: '3.1', reference: '0.10.10-2sarge10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-common is vulnerable in Debian 3.1.\nUpgrade to ethereal-common_0.10.10-2sarge10\n');
}
if (deb_check(prefix: 'ethereal-dev', release: '3.1', reference: '0.10.10-2sarge10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-dev is vulnerable in Debian 3.1.\nUpgrade to ethereal-dev_0.10.10-2sarge10\n');
}
if (deb_check(prefix: 'tethereal', release: '3.1', reference: '0.10.10-2sarge10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tethereal is vulnerable in Debian 3.1.\nUpgrade to tethereal_0.10.10-2sarge10\n');
}
if (deb_check(prefix: 'ethereal', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian 4.0.\nUpgrade to ethereal_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'ethereal-common', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-common is vulnerable in Debian 4.0.\nUpgrade to ethereal-common_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'ethereal-dev', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-dev is vulnerable in Debian 4.0.\nUpgrade to ethereal-dev_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'tethereal', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tethereal is vulnerable in Debian 4.0.\nUpgrade to tethereal_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'tshark', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tshark is vulnerable in Debian 4.0.\nUpgrade to tshark_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'wireshark', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian 4.0.\nUpgrade to wireshark_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'wireshark-common', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark-common is vulnerable in Debian 4.0.\nUpgrade to wireshark-common_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'wireshark-dev', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark-dev is vulnerable in Debian 4.0.\nUpgrade to wireshark-dev_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'wireshark', release: '4.0', reference: '0.99.4-5.etch.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian etch.\nUpgrade to wireshark_0.99.4-5.etch.1\n');
}
if (deb_check(prefix: 'wireshark', release: '3.1', reference: '0.10.10-2sarge10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian sarge.\nUpgrade to wireshark_0.10.10-2sarge10\n');
}
if (w) { security_hole(port: 0, data: desc); }
