# This script was automatically generated from the dsa-1417
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Tilghman Lesher discovered that the logging engine of Asterisk, a free
software PBX and telephony toolkit performs insufficient sanitising of
call-related data, which may lead to SQL injection.
For the old stable distribution (sarge), this problem has been fixed
in version 1:1.0.7.dfsg.1-2sarge6.
For the stable distribution (etch), this problem has been fixed in
version 1:1.2.13~dfsg-2etch2. Updated packages for ia64 will be provided
later.
We recommend that you upgrade your asterisk packages.


Solution : http://www.debian.org/security/2007/dsa-1417
Risk factor : High';

if (description) {
 script_id(29191);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1417");
 script_cve_id("CVE-2007-6170");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1417] DSA-1417-1 asterisk");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1417-1 asterisk");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'asterisk', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian 3.1.\nUpgrade to asterisk_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-config', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-config is vulnerable in Debian 3.1.\nUpgrade to asterisk-config_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-dev', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-dev is vulnerable in Debian 3.1.\nUpgrade to asterisk-dev_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-doc', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-doc is vulnerable in Debian 3.1.\nUpgrade to asterisk-doc_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-gtk-console', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-gtk-console is vulnerable in Debian 3.1.\nUpgrade to asterisk-gtk-console_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-h323', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-h323 is vulnerable in Debian 3.1.\nUpgrade to asterisk-h323_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-sounds-main', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-sounds-main is vulnerable in Debian 3.1.\nUpgrade to asterisk-sounds-main_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk-web-vmail', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk-web-vmail is vulnerable in Debian 3.1.\nUpgrade to asterisk-web-vmail_1.0.7.dfsg.1-2sarge6\n');
}
if (deb_check(prefix: 'asterisk', release: '4.0', reference: '1.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian etch.\nUpgrade to asterisk_1.2\n');
}
if (deb_check(prefix: 'asterisk', release: '3.1', reference: '1.0.7.dfsg.1-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package asterisk is vulnerable in Debian sarge.\nUpgrade to asterisk_1.0.7.dfsg.1-2sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
