# This script was automatically generated from the dsa-1418
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that Cacti, a tool to monitor systems and networks,
performs insufficient input sanitising, which allows SQL injection.
For the oldstable distribution (sarge) this problem has been fixed in
version 0.8.6c-7sarge5.
For the stable distribution (etch) this problem has been fixed in
version 0.8.6i-3.2.
For the unstable distribution (sid) this problem has been fixed in
version 0.8.7a-1.
We recommend that you upgrade your cacti package.


Solution : http://www.debian.org/security/2007/dsa-1418
Risk factor : High';

if (description) {
 script_id(29192);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1418");
 script_cve_id("CVE-2007-6035");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1418] DSA-1418-1 cacti");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1418-1 cacti");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'cacti', release: '3.1', reference: '0.8.6c-7sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian 3.1.\nUpgrade to cacti_0.8.6c-7sarge5\n');
}
if (deb_check(prefix: 'cacti', release: '4.0', reference: '0.8.6i-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian 4.0.\nUpgrade to cacti_0.8.6i-3.2\n');
}
if (deb_check(prefix: 'cacti', release: '4.0', reference: '0.8.6i-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian etch.\nUpgrade to cacti_0.8.6i-3.2\n');
}
if (deb_check(prefix: 'cacti', release: '3.1', reference: '0.8.6c-7sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian sarge.\nUpgrade to cacti_0.8.6c-7sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
