# This script was automatically generated from the dsa-1422
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Rafal Wojtczuk of McAfee AVERT Research discovered that e2fsprogs, the
ext2 file system utilities and libraries, contained multiple
integer overflows in memory allocations, based on sizes taken directly 
from filesystem information.  These could result in heap-based
overflows potentially allowing the execution of arbitrary code.
For the stable distribution (etch), this problem has been fixed in version
1.39+1.40-WIP-2006.11.14+dfsg-2etch1.
For the unstable distribution (sid), this problem will be fixed shortly.
We recommend that you upgrade your e2fsprogs package.


Solution : http://www.debian.org/security/2007/dsa-1422
Risk factor : High';

if (description) {
 script_id(29257);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1422");
 script_cve_id("CVE-2007-5497");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1422] DSA-1422-1 e2fsprogs");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1422-1 e2fsprogs");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'comerr-dev', release: '4.0', reference: '2.1-1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package comerr-dev is vulnerable in Debian 4.0.\nUpgrade to comerr-dev_2.1-1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'e2fsck-static', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package e2fsck-static is vulnerable in Debian 4.0.\nUpgrade to e2fsck-static_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'e2fslibs', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package e2fslibs is vulnerable in Debian 4.0.\nUpgrade to e2fslibs_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'e2fslibs-dev', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package e2fslibs-dev is vulnerable in Debian 4.0.\nUpgrade to e2fslibs-dev_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'e2fsprogs', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package e2fsprogs is vulnerable in Debian 4.0.\nUpgrade to e2fsprogs_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'libblkid-dev', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libblkid-dev is vulnerable in Debian 4.0.\nUpgrade to libblkid-dev_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'libblkid1', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libblkid1 is vulnerable in Debian 4.0.\nUpgrade to libblkid1_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'libcomerr2', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libcomerr2 is vulnerable in Debian 4.0.\nUpgrade to libcomerr2_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'libss2', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libss2 is vulnerable in Debian 4.0.\nUpgrade to libss2_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'libuuid1', release: '4.0', reference: '1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libuuid1 is vulnerable in Debian 4.0.\nUpgrade to libuuid1_1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'ss-dev', release: '4.0', reference: '2.0-1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ss-dev is vulnerable in Debian 4.0.\nUpgrade to ss-dev_2.0-1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'uuid-dev', release: '4.0', reference: '1.2-1.39+1.40-WIP-2006.11.14+dfsg-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package uuid-dev is vulnerable in Debian 4.0.\nUpgrade to uuid-dev_1.2-1.39+1.40-WIP-2006.11.14+dfsg-2etch1\n');
}
if (deb_check(prefix: 'e2fsprogs', release: '4.0', reference: '1.39+1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package e2fsprogs is vulnerable in Debian etch.\nUpgrade to e2fsprogs_1.39+1\n');
}
if (w) { security_hole(port: 0, data: desc); }
