# This script was automatically generated from the dsa-1425
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:
    Jesse Ruderman and Petko D. Petkov discovered that the URI handler
    for JAR archives allows cross-site scripting.
    Several crashes in the layout engine were discovered, which might
    allow the execution of arbitrary code.
    Gregory Fleischer discovered a race condition in the handling of
    the <q>window.location</q> property, which might lead to cross-site
    request forgery.
The oldstable distribution (sarge) doesn\'t contain xulrunner.
For the stable distribution (etch) these problems have been fixed in
version 1.8.0.14~pre071019c-0etch1.
For the unstable distribution (sid) these problems have been fixed in
version 1.8.1.11-1.
We recommend that you upgrade your xulrunner packages.


Solution : http://www.debian.org/security/2007/dsa-1425
Risk factor : High';

if (description) {
 script_id(29260);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1425");
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1425] DSA-1425-1 xulrunner");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1425-1 xulrunner");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian etch.\nUpgrade to xulrunner_1.8.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
