# This script was automatically generated from the dsa-1438
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several vulnerabilities have been discovered in GNU Tar. The Common
Vulnerabilities and Exposures project identifies the following problems:

     
     A directory traversal vulnerability enables attackers using
     specially crafted archives to extract contents outside the
     directory tree created by tar.
     
     
     A stack-based buffer overflow in the file name checking code may
     lead to arbitrary code execution when processing maliciously
     crafted archives.
     

For the old stable distribution (sarge), these problems have been
fixed in version 1.14-2.4.


For the stable distribution (etch), these problems have been fixed in
version 1.16-2etch1.


For the unstable distribution (sid), these problems have been fixed in
version 1.18-2.


We recommend that you upgrade your tar package.



Solution : http://www.debian.org/security/2007/dsa-1438
Risk factor : High';

if (description) {
 script_id(29805);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1438");
 script_cve_id("CVE-2007-4131", "CVE-2007-4476");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1438] DSA-1438-1 tar");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1438-1 tar");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'tar', release: '3.1', reference: '1.14-2.4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tar is vulnerable in Debian 3.1.\nUpgrade to tar_1.14-2.4\n');
}
if (deb_check(prefix: 'tar', release: '4.0', reference: '1.16-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tar is vulnerable in Debian 4.0.\nUpgrade to tar_1.16-2etch1\n');
}
if (deb_check(prefix: 'tar', release: '4.0', reference: '1.16-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tar is vulnerable in Debian etch.\nUpgrade to tar_1.16-2etch1\n');
}
if (deb_check(prefix: 'tar', release: '3.1', reference: '1.14-2.4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tar is vulnerable in Debian sarge.\nUpgrade to tar_1.14-2.4\n');
}
if (w) { security_hole(port: 0, data: desc); }
