# This script was automatically generated from the dsa-1439
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Henning Pingel discovered that TYPO3, a web content management framework,
performs insufficient input sanitising, making it vulnerable to SQL
injection by logged-in backend users.


The old stable distribution (sarge) doesn\'t contain typo3-src.


For the stable distribution (etch), this problem has been fixed in
version 4.0.2+debian-4.


For the unstable distribution (sid) and for the testing distribution
(lenny), this problem has been fixed in version 4.1.5-1.


We recommend that you upgrade your typo3-src packages.



Solution : http://www.debian.org/security/2007/dsa-1439
Risk factor : High';

if (description) {
 script_id(29806);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1439");
 script_cve_id("CVE-2007-6381");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1439] DSA-1439-1 typo3-src");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1439-1 typo3-src");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'typo3', release: '4.0', reference: '4.0.2+debian-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package typo3 is vulnerable in Debian 4.0.\nUpgrade to typo3_4.0.2+debian-4\n');
}
if (deb_check(prefix: 'typo3-src-4.0', release: '4.0', reference: '4.0.2+debian-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package typo3-src-4.0 is vulnerable in Debian 4.0.\nUpgrade to typo3-src-4.0_4.0.2+debian-4\n');
}
if (deb_check(prefix: 'typo3-src', release: '4.0', reference: '4.0.2+debian-4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package typo3-src is vulnerable in Debian etch.\nUpgrade to typo3-src_4.0.2+debian-4\n');
}
if (w) { security_hole(port: 0, data: desc); }
