# This script was automatically generated from the dsa-1446
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to denial of service. The
Common Vulnerabilities and Exposures project identifies the following
problems:

    
    The RPL dissector could be tricked into an infinite loop.
    
    
    The CIP dissector could be tricked into excessive memory
    allocation.
    

For the old stable distribution (sarge), these problems have been fixed in
version 0.10.10-2sarge11. (In Sarge Wireshark used to be called Ethereal).


For the stable distribution (etch), these problems have been fixed in
version 0.99.4-5.etch.2.


For the unstable distribution (sid), these problems have been fixed in
version 0.99.7-1.


We recommend that you upgrade your wireshark packages.



Solution : http://www.debian.org/security/2008/dsa-1446
Risk factor : High';

if (description) {
 script_id(29840);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1446");
 script_cve_id("CVE-2007-6450", "CVE-2007-6451");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1446] DSA-1446-1 wireshark");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1446-1 wireshark");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ethereal', release: '3.1', reference: '0.10.10-2sarge11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian 3.1.\nUpgrade to ethereal_0.10.10-2sarge11\n');
}
if (deb_check(prefix: 'ethereal-common', release: '3.1', reference: '0.10.10-2sarge11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-common is vulnerable in Debian 3.1.\nUpgrade to ethereal-common_0.10.10-2sarge11\n');
}
if (deb_check(prefix: 'ethereal-dev', release: '3.1', reference: '0.10.10-2sarge11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-dev is vulnerable in Debian 3.1.\nUpgrade to ethereal-dev_0.10.10-2sarge11\n');
}
if (deb_check(prefix: 'tethereal', release: '3.1', reference: '0.10.10-2sarge11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tethereal is vulnerable in Debian 3.1.\nUpgrade to tethereal_0.10.10-2sarge11\n');
}
if (deb_check(prefix: 'ethereal', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian 4.0.\nUpgrade to ethereal_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'ethereal-common', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-common is vulnerable in Debian 4.0.\nUpgrade to ethereal-common_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'ethereal-dev', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-dev is vulnerable in Debian 4.0.\nUpgrade to ethereal-dev_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'tethereal', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tethereal is vulnerable in Debian 4.0.\nUpgrade to tethereal_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'tshark', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tshark is vulnerable in Debian 4.0.\nUpgrade to tshark_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'wireshark', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian 4.0.\nUpgrade to wireshark_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'wireshark-common', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark-common is vulnerable in Debian 4.0.\nUpgrade to wireshark-common_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'wireshark-dev', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark-dev is vulnerable in Debian 4.0.\nUpgrade to wireshark-dev_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'wireshark', release: '4.0', reference: '0.99.4-5.etch.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian etch.\nUpgrade to wireshark_0.99.4-5.etch.2\n');
}
if (deb_check(prefix: 'wireshark', release: '3.1', reference: '0.10.10-2sarge11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wireshark is vulnerable in Debian sarge.\nUpgrade to wireshark_0.10.10-2sarge11\n');
}
if (w) { security_hole(port: 0, data: desc); }
