# This script was automatically generated from the dsa-1449
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that loop-aes-utils, tools for mounting and manipulating
filesystems, didn\'t drop privileged user and group permissions in the correct order
in the mount and umount commands.  This could potentially allow a local
user to gain additional privileges.
For the old stable distribution (sarge), this problem has been fixed in
version 2.12p-4sarge2.
For the stable distribution (etch), this problem has been fixed in version
2.12r-15+etch1.
We recommend that you upgrade your loop-aes-utils package.


Solution : http://www.debian.org/security/2008/dsa-1449
Risk factor : High';

if (description) {
 script_id(29858);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1449");
 script_cve_id("CVE-2007-5191");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1449] DSA-1449-1 loop-aes-utils");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1449-1 loop-aes-utils");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'loop-aes-utils', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-utils is vulnerable in Debian 3.1.\nUpgrade to loop-aes-utils_2.12p-4sarge2\n');
}
if (deb_check(prefix: 'loop-aes-utils', release: '4.0', reference: '2.12r-15+etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-utils is vulnerable in Debian 4.0.\nUpgrade to loop-aes-utils_2.12r-15+etch1\n');
}
if (deb_check(prefix: 'loop-aes-utils', release: '4.0', reference: '2.12r-15+etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-utils is vulnerable in Debian etch.\nUpgrade to loop-aes-utils_2.12r-15+etch1\n');
}
if (deb_check(prefix: 'loop-aes-utils', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-utils is vulnerable in Debian sarge.\nUpgrade to loop-aes-utils_2.12p-4sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
