# This script was automatically generated from the dsa-1454
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Greg MacManus discovered an integer overflow in the font handling of
libfreetype, a FreeType 2 font engine, which might lead to denial of
service or possibly the execution of arbitrary code if a user is tricked
into opening a malformed font.


For the old stable distribution (sarge) this problem will be fixed
soon.


For the stable distribution (etch), this problem has been fixed in
version 2.2.1-5+etch2.


For the unstable distribution (sid), this problem has been fixed in
version 2.3.5-1.


We recommend that you upgrade your freetype packages.



Solution : http://www.debian.org/security/2008/dsa-1454
Risk factor : High';

if (description) {
 script_id(29873);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1454");
 script_cve_id("CVE-2007-1351");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1454] DSA-1454-1 freetype");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1454-1 freetype");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'freetype2-demos', release: '4.0', reference: '2.2.1-5+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package freetype2-demos is vulnerable in Debian 4.0.\nUpgrade to freetype2-demos_2.2.1-5+etch2\n');
}
if (deb_check(prefix: 'libfreetype6', release: '4.0', reference: '2.2.1-5+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libfreetype6 is vulnerable in Debian 4.0.\nUpgrade to libfreetype6_2.2.1-5+etch2\n');
}
if (deb_check(prefix: 'libfreetype6-dev', release: '4.0', reference: '2.2.1-5+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libfreetype6-dev is vulnerable in Debian 4.0.\nUpgrade to libfreetype6-dev_2.2.1-5+etch2\n');
}
if (deb_check(prefix: 'freetype', release: '4.0', reference: '2.2.1-5+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package freetype is vulnerable in Debian etch.\nUpgrade to freetype_2.2.1-5+etch2\n');
}
if (w) { security_hole(port: 0, data: desc); }
