# This script was automatically generated from the dsa-1460
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several local vulnerabilities have been discovered in PostgreSQL, an
object-relational SQL database. The Common Vulnerabilities and Exposures
project identifies the following problems:

    
    It was discovered that the DBLink module performed insufficient
    credential validation. This issue is also tracked as CVE-2007-6601,
    since the initial upstream fix was incomplete.
    
    
    Tavis Ormandy and Will Drewry discovered that a bug in the handling
    of back-references inside the regular expressions engine could lead
    to an out of bounds read, resulting in a crash. This constitutes only
    a security problem if an application using ProgreSQL processes
    regular expressions from untrusted sources.
    
    
    Tavis Ormandy and Will Drewry discovered that the optimizer for regular
    expression could be tricked into an infinite loop, resulting in denial
    of service. This constitutes only a security problem if an application
    using ProgreSQL processes regular expressions from untrusted sources.
    
    
    Tavis Ormandy and Will Drewry discovered that the optimizer for regular
    expression could be tricked massive resource consumption. This
    constitutes only a security problem if an application using ProgreSQL
    processes regular expressions from untrusted sources.
    
    
    Functions in index expressions could lead to privilege escalation. For
    a more in depth explanation please see the upstream announce available
    at http://www.postgresql.org/about/news.905.
    

The old stable distribution (sarge), doesn\'t contain postgresql-8.1.


For the stable distribution (etch), these problems have been fixed in version
postgresql-8.1 8.1.11-0etch1.


For the unstable distribution (sid), these problems have been fixed in
version 8.2.6-1 of postgresql-8.2.


We recommend that you upgrade your postgresql-8.1 (8.1.11-0etch1) package.



Solution : http://www.debian.org/security/2008/dsa-1460
Risk factor : High';

if (description) {
 script_id(29937);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1460");
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1460] DSA-1460-1 postgresql-8.1");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1460-1 postgresql-8.1");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libecpg-compat2', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-compat2 is vulnerable in Debian 4.0.\nUpgrade to libecpg-compat2_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'libecpg-dev', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-dev is vulnerable in Debian 4.0.\nUpgrade to libecpg-dev_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'libecpg5', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg5 is vulnerable in Debian 4.0.\nUpgrade to libecpg5_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'libpgtypes2', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtypes2 is vulnerable in Debian 4.0.\nUpgrade to libpgtypes2_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'libpq-dev', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq-dev is vulnerable in Debian 4.0.\nUpgrade to libpq-dev_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'libpq4', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq4 is vulnerable in Debian 4.0.\nUpgrade to libpq4_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-client-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-client-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-contrib-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-contrib-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-doc-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-doc-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plperl-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plperl-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plperl-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plpython-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plpython-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plpython-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-pltcl-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-pltcl-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-pltcl-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-server-dev-8.1', release: '4.0', reference: '8.1.11-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-server-dev-8.1 is vulnerable in Debian 4.0.\nUpgrade to postgresql-server-dev-8.1_8.1.11-0etch1\n');
}
if (deb_check(prefix: 'postgresql-8.1', release: '4.0', reference: 'postgresql-8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-8.1 is vulnerable in Debian etch.\nUpgrade to postgresql-8.1_postgresql-8\n');
}
if (w) { security_hole(port: 0, data: desc); }
