# This script was automatically generated from the dsa-1463
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several local vulnerabilities have been discovered in PostgreSQL, an
object-relational SQL database. The Common Vulnerabilities and Exposures
project identifies the following problems:

    
    It was discovered that the DBLink module performed insufficient
    credential validation. This issue is also tracked as CVE-2007-6601,
    since the initial upstream fix was incomplete.
    
    
    Tavis Ormandy and Will Drewry discovered that a bug in the handling
    of back-references inside the regular expressions engine could lead
    to an out of bands read, resulting in a crash. This constitutes only
    a security problem if an application using ProgreSQL processes
    regular expressions from untrusted sources.
    
    
    Tavis Ormandy and Will Drewry discovered that the optimizer for regular
    expression could be tricked into an infinite loop, resulting in denial
    of service. This constitutes only a security problem if an application
    using ProgreSQL processes regular expressions from untrusted sources.
    
    
    Tavis Ormandy and Will Drewry discovered that the optimizer for regular
    expression could be tricked massive ressource consumption. This
    constitutes only a security problem if an application using ProgreSQL
    processes regular expressions from untrusted sources.
    
    
    Functions in index expressions could lead to privilege escalation. For
    a more in depth explanation please see the upstream announce available
    at http://www.postgresql.org/about/news.905.
    

For the old stable distribution (sarge), some of these problems have been
fixed in version 7.4.7-6sarge6 of the postgresql package. Please note that
the fix for CVE-2007-6600 and for the handling of regular expressions
hasn\'t been backported due to the intrusiveness of the fix. We recommend
to upgrade to the stable distribution if these vulnerabilities affect your
setup.


For the stable distribution (etch), these problems have been fixed in
version 7.4.19-0etch1.


The unstable distribution (sid) no longer contains postgres-7.4


We recommend that you upgrade your postgresql-7.4 packages.



Solution : http://www.debian.org/security/2008/dsa-1463
Risk factor : High';

if (description) {
 script_id(29968);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1463");
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1463] DSA-1463-1 postgresql-7.4");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1463-1 postgresql-7.4");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libecpg-dev', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-dev is vulnerable in Debian 3.1.\nUpgrade to libecpg-dev_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'libecpg4', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg4 is vulnerable in Debian 3.1.\nUpgrade to libecpg4_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'libpgtcl', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl is vulnerable in Debian 3.1.\nUpgrade to libpgtcl_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'libpgtcl-dev', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl-dev is vulnerable in Debian 3.1.\nUpgrade to libpgtcl-dev_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'libpq3', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq3 is vulnerable in Debian 3.1.\nUpgrade to libpq3_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql is vulnerable in Debian 3.1.\nUpgrade to postgresql_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql-client', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client is vulnerable in Debian 3.1.\nUpgrade to postgresql-client_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql-contrib', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib is vulnerable in Debian 3.1.\nUpgrade to postgresql-contrib_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql-dev', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-dev is vulnerable in Debian 3.1.\nUpgrade to postgresql-dev_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql-doc', release: '3.1', reference: '7.4.7-6sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc is vulnerable in Debian 3.1.\nUpgrade to postgresql-doc_7.4.7-6sarge6\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-client-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-client-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-contrib-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-contrib-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-doc-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-doc-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plperl-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plperl-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plperl-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plpython-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plpython-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plpython-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-pltcl-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-pltcl-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-pltcl-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-server-dev-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-server-dev-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-server-dev-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '4.0', reference: '7.4.19-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian etch.\nUpgrade to postgresql-7.4_7.4.19-0etch1\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '3.1', reference: '7.4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian sarge.\nUpgrade to postgresql-7.4_7.4\n');
}
if (w) { security_hole(port: 0, data: desc); }
