# This script was automatically generated from the dsa-1465
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Felipe Sateler discovered that apt-listchanges, a package change history
notification tool, used unsafe paths when importing its python libraries.
This could allow the execution of arbitrary shell commands if the root user
executed the command in a directory which other local users may write
to.
For the old stable distribution (sarge), this problem was not present.
For the stable distribution (etch), this problem has been fixed in version
2.72.5etch1.
For the unstable distribution (sid), this problem has been fixed in version
2.82.
We recommend that you upgrade your apt-listchanges package.


Solution : http://www.debian.org/security/2008/dsa-1465
Risk factor : High';

if (description) {
 script_id(30000);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1465");
 script_cve_id("CVE-2008-0302");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1465] DSA-1465-2 apt-listchanges");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1465-2 apt-listchanges");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'apt-listchanges', release: '4.0', reference: '2.72.5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package apt-listchanges is vulnerable in Debian 4.0.\nUpgrade to apt-listchanges_2.72.5etch2\n');
}
if (deb_check(prefix: 'apt-listchanges', release: '4.0', reference: '2.72.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package apt-listchanges is vulnerable in Debian etch.\nUpgrade to apt-listchanges_2.72.5etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
