# This script was automatically generated from the dsa-1472
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Luigi Auriemma discovered that the Xine media player library performed
insufficient input sanitising during the handling of RTSP streams,
which could lead to the execution of arbitrary code.
For the old stable distribution (sarge), this problem has been fixed
in version 1.0.1-1sarge6.
For the stable distribution (etch), this problem has been fixed in
version 1.1.2+dfsg-5.
For the testing distribution (lenny), this problem has been fixed in
version 1.1.8-3+lenny1.
For the unstable distribution (sid), this problem will be fixed soon.
We recommend that you upgrade your xine-lib packages.


Solution : http://www.debian.org/security/2008/dsa-1472
Risk factor : High';

if (description) {
 script_id(30064);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1472");
 script_cve_id("CVE-2008-0225");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1472] DSA-1472-1 xine-lib");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1472-1 xine-lib");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libxine-dev', release: '3.1', reference: '1.0.1-1sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine-dev is vulnerable in Debian 3.1.\nUpgrade to libxine-dev_1.0.1-1sarge6\n');
}
if (deb_check(prefix: 'libxine1', release: '3.1', reference: '1.0.1-1sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine1 is vulnerable in Debian 3.1.\nUpgrade to libxine1_1.0.1-1sarge6\n');
}
if (deb_check(prefix: 'libxine-dev', release: '4.0', reference: '1.1.2+dfsg-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine-dev is vulnerable in Debian 4.0.\nUpgrade to libxine-dev_1.1.2+dfsg-5\n');
}
if (deb_check(prefix: 'libxine1', release: '4.0', reference: '1.1.2+dfsg-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine1 is vulnerable in Debian 4.0.\nUpgrade to libxine1_1.1.2+dfsg-5\n');
}
if (deb_check(prefix: 'libxine1-dbg', release: '4.0', reference: '1.1.2+dfsg-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine1-dbg is vulnerable in Debian 4.0.\nUpgrade to libxine1-dbg_1.1.2+dfsg-5\n');
}
if (deb_check(prefix: 'xine-lib', release: '4.0', reference: '1.1.2+dfsg-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian etch.\nUpgrade to xine-lib_1.1.2+dfsg-5\n');
}
if (deb_check(prefix: 'xine-lib', release: '3.1', reference: '1.0.1-1sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian sarge.\nUpgrade to xine-lib_1.0.1-1sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
