# This script was automatically generated from the dsa-1485
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Icedove mail
client, an unbranded version of the Thunderbird client. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Jesse Ruderman, Kai Engert, Martijn Wargers, Mats Palmgren and Paul
    Nickerson discovered crashes in the layout engine, which might allow
    the execution of arbitrary code.
    Carsten Book, Wesley Garland, Igor Bukanov, <q>moz_bug_r_a4</q>, <q>shutdown</q>,
    Philip Taylor and <q>tgirmann</q> discovered crashes in the Javascript
    engine, which might allow the execution of arbitrary code.
    <q>moz_bug_r_a4</q> and Boris Zbarsky discovered several
    vulnerabilities in Javascript handling, which could allow
    privilege escalation.
    Gerry Eisenhaur and <q>moz_bug_r_a4</q> discovered that a directory
    traversal vulnerability in chrome: URI handling could lead to
    information disclosure.
    David Bloom discovered a race condition in the image handling of
    designMode elements, which can lead to information disclosure or
    potentially the execution of arbitrary code.
    Michal Zalewski discovered that timers protecting security-sensitive
    dialogs (which disable dialog elements until a timeout is reached)
    could be bypassed by window focus changes through Javascript.
The Mozilla products in the old stable distribution (sarge) are no
longer supported with security updates.
For the stable distribution (etch), these problems have been fixed in
version 1.5.0.13+1.5.0.15b.dfsg1-0etch1.
We recommend that you upgrade your icedove packages.


Solution : http://www.debian.org/security/2008/dsa-1485
Risk factor : High';

if (description) {
 script_id(30225);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1485");
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0416", "CVE-2008-0417", "CVE-2008-0418");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1485] DSA-1485-1 icedove");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1485-1 icedove");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'icedove', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove is vulnerable in Debian 4.0.\nUpgrade to icedove_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-dbg', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-dbg is vulnerable in Debian 4.0.\nUpgrade to icedove-dbg_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-dev', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-dev is vulnerable in Debian 4.0.\nUpgrade to icedove-dev_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-gnome-support', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-gnome-support is vulnerable in Debian 4.0.\nUpgrade to icedove-gnome-support_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-inspector', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-inspector is vulnerable in Debian 4.0.\nUpgrade to icedove-inspector_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-typeaheadfind', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to icedove-typeaheadfind_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-dev', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-dev is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-dev_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-inspector', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-inspector_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-typeaheadfind', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-typeaheadfind_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird is vulnerable in Debian 4.0.\nUpgrade to thunderbird_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-dbg', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-dbg is vulnerable in Debian 4.0.\nUpgrade to thunderbird-dbg_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-dev', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-dev is vulnerable in Debian 4.0.\nUpgrade to thunderbird-dev_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-gnome-support', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-gnome-support is vulnerable in Debian 4.0.\nUpgrade to thunderbird-gnome-support_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-inspector', release: '4.0', reference: '1.5.0.13+1.5.0.15a.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-inspector is vulnerable in Debian 4.0.\nUpgrade to thunderbird-inspector_1.5.0.13+1.5.0.15a.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-typeaheadfind', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to thunderbird-typeaheadfind_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove', release: '4.0', reference: '1.5.0.13+1.5.0.15b.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove is vulnerable in Debian etch.\nUpgrade to icedove_1.5.0.13+1.5.0.15b.dfsg1-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
