# This script was automatically generated from the dsa-1488
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in phpBB, a web
based bulletin board.
The Common Vulnerabilities and Exposures project identifies the
following problems:
	Private messaging allowed cross site request forgery, making
	it possible to delete all private messages of a user by sending
	them to a crafted web page.
	Cross site request forgery enabled an attacker to perform various
	actions on behalf of a logged in user. (Applies to sarge only.)
	A negative start parameter could allow an attacker to create
	invalid output. (Applies to sarge only.)
	Redirection targets were not fully checked, leaving room for
	unauthorised external redirections via a phpBB forum.
	(Applies to sarge only.)
	An authenticated forum administrator may upload files of any
	type by using specially crafted filenames. (Applies to sarge only.)
For the old stable distribution (sarge), these problems have been
fixed in version 2.0.13+1-6sarge4.
For the stable distribution (etch), these problems have been fixed
in version 2.0.21-7.
For the unstable distribution (sid) these problems have been fixed
in version 2.0.22-3.
We recommend that you upgrade your phpbb2 package.


Solution : http://www.debian.org/security/2008/dsa-1488
Risk factor : High';

if (description) {
 script_id(30227);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1488");
 script_cve_id("CVE-2006-4758", "CVE-2006-6508", "CVE-2006-6839", "CVE-2006-6840", "CVE-2006-6841", "CVE-2008-0471");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1488] DSA-1488-1 phpbb2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1488-1 phpbb2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'phpbb2', release: '3.1', reference: '2.0.13-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2 is vulnerable in Debian 3.1.\nUpgrade to phpbb2_2.0.13-6sarge4\n');
}
if (deb_check(prefix: 'phpbb2-conf-mysql', release: '3.1', reference: '2.0.13-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2-conf-mysql is vulnerable in Debian 3.1.\nUpgrade to phpbb2-conf-mysql_2.0.13-6sarge4\n');
}
if (deb_check(prefix: 'phpbb2-languages', release: '3.1', reference: '2.0.13-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2-languages is vulnerable in Debian 3.1.\nUpgrade to phpbb2-languages_2.0.13-6sarge4\n');
}
if (deb_check(prefix: 'phpbb2', release: '4.0', reference: '2.0.21-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2 is vulnerable in Debian 4.0.\nUpgrade to phpbb2_2.0.21-7\n');
}
if (deb_check(prefix: 'phpbb2-conf-mysql', release: '4.0', reference: '2.0.21-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2-conf-mysql is vulnerable in Debian 4.0.\nUpgrade to phpbb2-conf-mysql_2.0.21-7\n');
}
if (deb_check(prefix: 'phpbb2-languages', release: '4.0', reference: '2.0.21-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2-languages is vulnerable in Debian 4.0.\nUpgrade to phpbb2-languages_2.0.21-7\n');
}
if (deb_check(prefix: 'phpbb2', release: '4.0', reference: '2.0.21-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2 is vulnerable in Debian etch.\nUpgrade to phpbb2_2.0.21-7\n');
}
if (deb_check(prefix: 'phpbb2', release: '3.1', reference: '2.0.13+1-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpbb2 is vulnerable in Debian sarge.\nUpgrade to phpbb2_2.0.13+1-6sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
