# This script was automatically generated from the dsa-1493
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local/remote vulnerabilities have been discovered in the image
loading library for the Simple DirectMedia Layer 1.2. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Gynvael Coldwind discovered a buffer overflow in GIF image parsing,
    which could result in denial of service and potentially the
    execution of arbitrary code.
    It was discovered that a buffer overflow in IFF ILBM image parsing
    could result in denial of service and potentially the execution of
    arbitrary code.
For the old stable distribution (sarge), these problems have been fixed
in version 1.2.4-1etch1. Due to a copy &amp; paste error <q>etch1</q> was appended
to the version number instead of <q>sarge1</q>. Since the update is otherwise
technically correct, the update was not rebuild on the buildd network.
For the stable distribution (etch), these problems have been fixed in
version 1.2.5-2etch1.
We recommend that you upgrade your sdl-image1.2 packages.


Solution : http://www.debian.org/security/2008/dsa-1493
Risk factor : High';

if (description) {
 script_id(30232);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1493");
 script_cve_id("CVE-2007-6697", "CVE-2008-0554");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1493] DSA-1493-1 sdl-image1.2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1493-1 sdl-image1.2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libsdl-image1.2', release: '3.1', reference: '1.2.4-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsdl-image1.2 is vulnerable in Debian 3.1.\nUpgrade to libsdl-image1.2_1.2.4-1etch1\n');
}
if (deb_check(prefix: 'libsdl-image1.2-dev', release: '3.1', reference: '1.2.4-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsdl-image1.2-dev is vulnerable in Debian 3.1.\nUpgrade to libsdl-image1.2-dev_1.2.4-1etch1\n');
}
if (deb_check(prefix: 'libsdl-image1.2', release: '4.0', reference: '1.2.5-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsdl-image1.2 is vulnerable in Debian 4.0.\nUpgrade to libsdl-image1.2_1.2.5-2etch1\n');
}
if (deb_check(prefix: 'libsdl-image1.2-dev', release: '4.0', reference: '1.2.5-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsdl-image1.2-dev is vulnerable in Debian 4.0.\nUpgrade to libsdl-image1.2-dev_1.2.5-2etch1\n');
}
if (deb_check(prefix: 'sdl-image1.2', release: '4.0', reference: '1.2.5-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sdl-image1.2 is vulnerable in Debian etch.\nUpgrade to sdl-image1.2_1.2.5-2etch1\n');
}
if (deb_check(prefix: 'sdl-image1.2', release: '3.1', reference: '1.2.4-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sdl-image1.2 is vulnerable in Debian sarge.\nUpgrade to sdl-image1.2_1.2.4-1etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
