# This script was automatically generated from the dsa-1494
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The vmsplice system call did not properly verify address arguments
passed by user space processes, which allowed local attackers to
overwrite arbitrary kernel memory, gaining root privileges
(CVE-2008-0010,
CVE-2008-0600).
In the vserver-enabled kernels, a missing access check on certain
symlinks in /proc enabled local attackers to access resources in other
vservers (CVE-2008-0163).
For the stable distribution (etch), this problem has been fixed in version
2.6.18.dfsg.1-18etch1.
In addition to these fixes, this update also incorporates changes from the
upcoming point release of the stable distribution.
Some architecture builds were not yet available at the time of DSA-1494-1.
This update to DSA-1494 provides linux-2.6 packages for these remaining
architectures, as well as additional binary packages that are built
from source code provided by linux-2.6.
The old stable distribution (sarge) is not affected by this problem.
The unstable (sid) and testing distributions will be fixed soon.
We recommend that you upgrade your linux-2.6, fai-kernels, and
user-mode-linux packages.


Solution : http://www.debian.org/security/2008/dsa-1494
Risk factor : High';

if (description) {
 script_id(31028);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1494");
 script_cve_id("CVE-2008-0010", "CVE-2008-0163", "CVE-2008-0600");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1494] DSA-1494-2 linux-2.6");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1494-2 linux-2.6");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fai-kernels', release: '4.0', reference: '1.17+etch.18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fai-kernels is vulnerable in Debian 4.0.\nUpgrade to fai-kernels_1.17+etch.18etch1\n');
}
if (deb_check(prefix: 'linux-doc-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-doc-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-doc-2.6.18_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-486', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-486_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-686-bigmem_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-alpha', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-alpha_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-arm', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-arm is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-arm_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-hppa', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-hppa is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-hppa_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-i386', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-i386 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-i386_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-ia64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-ia64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-ia64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-mips', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-mips is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-mips_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-mipsel', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-mipsel is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-mipsel_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-powerpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-s390', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-s390_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-sparc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-sparc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-sparc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-generic_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-legacy_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-footbridge_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-iop32x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-itanium', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-itanium_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-ixp4xx_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-k7', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-k7_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-mckinley_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc64-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc-miboot_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-prep', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-prep_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-qemu', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-qemu_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r3k-kn02_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r4k-ip22_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r4k-kn04_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r5k-cobalt_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r5k-ip32_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-rpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-rpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s390', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s390_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s390x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s390x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s3c2410_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sb1-bcm91250a_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sb1a-bcm91480b_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc32_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc64-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-alpha_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-k7_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-powerpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-powerpc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-s390x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-sparc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-486', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-486_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-686-bigmem_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-generic_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-legacy_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-footbridge_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-iop32x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-itanium', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-itanium_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-ixp4xx_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-k7', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-k7_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-mckinley_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc64-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc-miboot_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-prep', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-prep_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-qemu', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-qemu_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r3k-kn02_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r4k-ip22_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r4k-kn04_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r5k-cobalt_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r5k-ip32_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-rpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-rpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390-tape', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390-tape is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390-tape_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s3c2410_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sb1-bcm91250a_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sb1a-bcm91480b_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc32_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc64-smp_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-alpha_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-k7_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-powerpc_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-powerpc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-s390x_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-sparc64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-manual-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-manual-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-manual-2.6.18_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-patch-debian-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-patch-debian-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-patch-debian-2.6.18_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-source-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-source-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-source-2.6.18_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-support-2.6.18-6', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-support-2.6.18-6 is vulnerable in Debian 4.0.\nUpgrade to linux-support-2.6.18-6_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-tree-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-tree-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-tree-2.6.18_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'user-mode-linux', release: '4.0', reference: '2.6.18-1um-2etch.18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package user-mode-linux is vulnerable in Debian 4.0.\nUpgrade to user-mode-linux_2.6.18-1um-2etch.18etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-18etch1\n');
}
if (deb_check(prefix: 'linux-2.6', release: '4.0', reference: '2.6.18.dfsg.1-18etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-2.6 is vulnerable in Debian etch.\nUpgrade to linux-2.6_2.6.18.dfsg.1-18etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
