# This script was automatically generated from the dsa-1495
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local/remote vulnerabilities have been discovered in two of
the plugins for the Nagios network monitoring and management system.
The Common Vulnerabilities and Exposures project identifies the
following problems:
    A buffer overflow has been discovered in the parser for HTTP
    Location headers (present in the check_http module).
    A buffer overflow has been discovered in the check_snmp module.
For the old stable distribution (sarge), these problems have been
fixed in version 1.4-6sarge1.
For the stable distribution (etch), these problems have been fixed in
version 1.4.5-1etch1.
We recommend that you upgrade your nagios-plugins package.


Solution : http://www.debian.org/security/2008/dsa-1495
Risk factor : High';

if (description) {
 script_id(31055);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1495");
 script_cve_id("CVE-2007-5198", "CVE-2007-5623");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1495] DSA-1495-1 nagios-plugins");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1495-1 nagios-plugins");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'nagios-plugins', release: '3.1', reference: '1.4-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins is vulnerable in Debian 3.1.\nUpgrade to nagios-plugins_1.4-6sarge1\n');
}
if (deb_check(prefix: 'nagios-plugins', release: '4.0', reference: '1.4.5-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins is vulnerable in Debian 4.0.\nUpgrade to nagios-plugins_1.4.5-1etch1\n');
}
if (deb_check(prefix: 'nagios-plugins-basic', release: '4.0', reference: '1.4.5-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins-basic is vulnerable in Debian 4.0.\nUpgrade to nagios-plugins-basic_1.4.5-1etch1\n');
}
if (deb_check(prefix: 'nagios-plugins-standard', release: '4.0', reference: '1.4.5-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins-standard is vulnerable in Debian 4.0.\nUpgrade to nagios-plugins-standard_1.4.5-1etch1\n');
}
if (deb_check(prefix: 'nagios-plugins', release: '4.0', reference: '1.4.5-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins is vulnerable in Debian etch.\nUpgrade to nagios-plugins_1.4.5-1etch1\n');
}
if (deb_check(prefix: 'nagios-plugins', release: '3.1', reference: '1.4-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nagios-plugins is vulnerable in Debian sarge.\nUpgrade to nagios-plugins_1.4-6sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
