# This script was automatically generated from the dsa-1496
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several buffer overflows have been discovered in the MPlayer movie player,
which might lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Felipe Manzano and Anibal Sacco discovered a buffer overflow in
    the demuxer for MOV files.
    Reimar Doeffinger discovered a buffer overflow in the FLAC header
    parsing.
    Adam Bozanich discovered a buffer overflow in the CDDB access code.
    Adam Bozanich discovered a buffer overflow in URL parsing.
The old stable distribution (sarge) doesn\'t contain mplayer.
For the stable distribution (etch), these problems have been fixed in
version 1.0~rc1-12etch2.
We recommend that you upgrade your mplayer packages.


Solution : http://www.debian.org/security/2008/dsa-1496
Risk factor : High';

if (description) {
 script_id(31056);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1496");
 script_cve_id("CVE-2008-0485", "CVE-2008-0486", "CVE-2008-0629", "CVE-2008-0630");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1496] DSA-1496-1 mplayer");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1496-1 mplayer");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mplayer', release: '4.0', reference: '1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mplayer is vulnerable in Debian etch.\nUpgrade to mplayer_1\n');
}
if (w) { security_hole(port: 0, data: desc); }
