# This script was automatically generated from the dsa-1499
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that specially crafted regular expressions involving
codepoints greater than 255 could cause a buffer overflow in the PCRE
library (CVE-2008-0674).
For the stable distribution (etch), this problem has been fixed in
version 6.7+7.4-3.
For the old stable distribution (sarge), this problem has been fixed in
version 4.5+7.4-2.
For the unstable distribution, this problem has been fixed in version
7.6-1.
We recommend that you upgrade your pcre3 package.


Solution : http://www.debian.org/security/2008/dsa-1499
Risk factor : High';

if (description) {
 script_id(31143);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1499");
 script_cve_id("CVE-2008-0674");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1499] DSA-1499-1 pcre3");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1499-1 pcre3");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libpcre3', release: '3.1', reference: '4.5+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3 is vulnerable in Debian 3.1.\nUpgrade to libpcre3_4.5+7.4-2\n');
}
if (deb_check(prefix: 'libpcre3-dev', release: '3.1', reference: '4.5+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3-dev is vulnerable in Debian 3.1.\nUpgrade to libpcre3-dev_4.5+7.4-2\n');
}
if (deb_check(prefix: 'pcregrep', release: '3.1', reference: '4.5+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcregrep is vulnerable in Debian 3.1.\nUpgrade to pcregrep_4.5+7.4-2\n');
}
if (deb_check(prefix: 'pgrep', release: '3.1', reference: '4.5+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pgrep is vulnerable in Debian 3.1.\nUpgrade to pgrep_4.5+7.4-2\n');
}
if (deb_check(prefix: 'libpcre3', release: '4.0', reference: '6.7+7.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3 is vulnerable in Debian 4.0.\nUpgrade to libpcre3_6.7+7.4-3\n');
}
if (deb_check(prefix: 'libpcre3-dev', release: '4.0', reference: '6.7+7.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3-dev is vulnerable in Debian 4.0.\nUpgrade to libpcre3-dev_6.7+7.4-3\n');
}
if (deb_check(prefix: 'libpcrecpp0', release: '4.0', reference: '6.7+7.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcrecpp0 is vulnerable in Debian 4.0.\nUpgrade to libpcrecpp0_6.7+7.4-3\n');
}
if (deb_check(prefix: 'pcregrep', release: '4.0', reference: '6.7+7.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcregrep is vulnerable in Debian 4.0.\nUpgrade to pcregrep_6.7+7.4-3\n');
}
if (deb_check(prefix: 'pcre3', release: '4.0', reference: '6.7+7.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcre3 is vulnerable in Debian etch.\nUpgrade to pcre3_6.7+7.4-3\n');
}
if (deb_check(prefix: 'pcre3', release: '3.1', reference: '4.5+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcre3 is vulnerable in Debian sarge.\nUpgrade to pcre3_4.5+7.4-2\n');
}
if (w) { security_hole(port: 0, data: desc); }
