# This script was automatically generated from the dsa-1504
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code.  The Common Vulnerabilities and Exposures project identifies the
following problems:
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted cramfs filesystem.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted ext2 filesystem.
    LMH reported an issue in the minix filesystem that allows local users
    with mount privileges to create a DoS (printk flood) by mounting a
    specially crafted corrupt filesystem.
    OpenVZ Linux kernel team reported an issue in the smbfs filesystem which
    can be exploited by local users to cause a DoS (oops) during mount.
    Ilja van Sprundel discovered that kernel memory could be leaked via the
    Bluetooth setsockopt call due to an uninitialized stack buffer. This
    could be used by local attackers to read the contents of sensitive kernel
    memory.
    Thomas Graf reported a typo in the DECnet protocol handler that could
    be used by a local attacker to overrun an array via crafted packets,
    potentially resulting in a Denial of Service (system crash).
    A similar issue exists in the IPV4 protocol handler and will be fixed
    in a subsequent update.
    Florian Zumbiehl discovered a memory leak in the PPPOE subsystem caused
    by releasing a socket before PPPIOCGCHAN is called upon it. This could
    be used by a local user to DoS a system by consuming all available memory.
    The PaX Team discovered a potential buffer overflow in the random number
    generator which may permit local users to cause a denial of service or
    gain additional privileges. This issue is not believed to effect default
    Debian installations where only root has sufficient privileges to exploit
    it.
    Adam Litke reported a potential local denial of service (oops) on
    powerpc platforms resulting from unchecked VMA expansion into address
    space reserved for hugetlb pages.
    Steve French reported that CIFS filesystems with CAP_UNIX enabled 
    were not honoring a process\' umask which may lead to unintentionally
    relaxed permissions.
    Wojciech Purczynski discovered that pdeath_signal was not being reset
    properly under certain conditions which may allow local users to gain
    privileges by sending arbitrary signals to suid binaries.
    Hugh Dickins discovered a potential local DoS (panic) in hugetlbfs.
    A misconversion of hugetlb_vmtruncate_list to prio_tree may allow
    local users to trigger a BUG_ON() call in exit_mmap.
    Alan Cox reported an issue in the aacraid driver that allows unprivileged
    local users to make ioctl calls which should be restricted to admin
    privileges.
    Wojciech Purczynski discovered a vulnerability that can be exploited
    by a local user to obtain superuser privileges on x86_64 systems.
    This resulted from improper clearing of
[...]

Solution : http://www.debian.org/security/2008/dsa-1504
Risk factor : High';

if (description) {
 script_id(31148);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1504");
 script_cve_id("CVE-2006-5823", "CVE-2006-6054", "CVE-2006-6058", "CVE-2006-7203", "CVE-2007-1353", "CVE-2007-2172", "CVE-2007-2525");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1504] DSA-1504-1 kernel-source-2.6.8");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1504-1 kernel-source-2.6.8");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fai-kernels', release: '3.1', reference: '1.9.1sarge8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fai-kernels is vulnerable in Debian 3.1.\nUpgrade to fai-kernels_1.9.1sarge8\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power3', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power3 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power3_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power3-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power3-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power3-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power4', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power4 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power4_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power4-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power4-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-powerpc', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-powerpc_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-powerpc-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-powerpc-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-doc-2.6.8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-doc-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-doc-2.6.8_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-itanium', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-itanium_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-itanium-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-itanium-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-mckinley', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-mckinley_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-mckinley-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-mckinley-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-generic', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-generic_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-k8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-k8 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-k8_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-k8-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-k8-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-k8-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-em64t-p4', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-em64t-p4 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-em64t-p4_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-em64t-p4-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-em64t-p4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-em64t-p4-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-32', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-32_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-32-smp', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-32-smp_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-386', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-386_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-64', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-64_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-64-smp', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-64-smp_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-686', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-686_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-686-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-686-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-generic', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-generic_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-itanium', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-itanium_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-itanium-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-itanium-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-k7', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-k7_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-k7-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-k7-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-mckinley', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-mckinley_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-mckinley-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-mckinley-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc32', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc32_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc64', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc64_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc64-smp', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc64-smp_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-itanium_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-itanium-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-mckinley_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-mckinley-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-generic', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-generic_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-k8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-k8 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-k8_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-k8-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-k8-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-k8-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-em64t-p4', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-em64t-p4 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-em64t-p4_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-em64t-p4-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-em64t-p4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-em64t-p4-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-32', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-32_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-32-smp', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-32-smp_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-386', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-386_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-64', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-64_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-64-smp', release: '3.1', reference: '2.6.8-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-64-smp_2.6.8-7sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-686', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-686_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-686-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-686-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-generic', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-generic_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-itanium', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-itanium_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-itanium-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-itanium-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-k7', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-k7_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-k7-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-k7-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-mckinley', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-mckinley_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-mckinley-smp', release: '3.1', reference: '2.6.8-15sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-mckinley-smp_2.6.8-15sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power3', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power3 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power3_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power3-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power3-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power3-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power4', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power4 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power4_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power4-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power4-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-powerpc', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-powerpc_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-powerpc-smp', release: '3.1', reference: '2.6.8-13sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-powerpc-smp_2.6.8-13sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390', release: '3.1', reference: '2.6.8-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390_2.6.8-6sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390-tape', release: '3.1', reference: '2.6.8-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390-tape is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390-tape_2.6.8-6sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390x', release: '3.1', reference: '2.6.8-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390x_2.6.8-6sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-smp', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-smp_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc32', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc32_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc64', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc64_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc64-smp', release: '3.1', reference: '2.6.8-16sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc64-smp_2.6.8-16sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-amiga', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-amiga is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-amiga_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-atari', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-atari is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-atari_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-bvme6000', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-bvme6000 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-bvme6000_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-hp', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-hp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-hp_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mac', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mac is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mac_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mvme147', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mvme147 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mvme147_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mvme16x', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mvme16x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mvme16x_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-q40', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-q40 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-q40_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-sun3', release: '3.1', reference: '2.6.8-5sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-sun3 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-sun3_2.6.8-5sarge1\n');
}
if (deb_check(prefix: 'kernel-patch-2.6.8-s390', release: '3.1', reference: '2.6.8-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.6.8-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.6.8-s390_2.6.8-6sarge1\n');
}
if (deb_check(prefix: 'kernel-patch-debian-2.6.8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-debian-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-debian-2.6.8_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-source-2.6.8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-source-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-source-2.6.8_2.6.8-17sarge1\n');
}
if (deb_check(prefix: 'kernel-tree-2.6.8', release: '3.1', reference: '2.6.8-17sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-tree-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-tree-2.6.8_2.6.8-17sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
