# This script was automatically generated from the dsa-1506
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceape internet
suite, an unbranded version of the Seamonkey Internet Suite. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Jesse Ruderman, Kai Engert, Martijn Wargers, Mats Palmgren and Paul
    Nickerson discovered crashes in the layout engine, which might allow
    the execution of arbitrary code.
    Carsten Book, Wesley Garland, Igor Bukanov, "moz_bug_r_a4", "shutdown",
    Philip Taylor and "tgirmann" discovered crashes in the Javascript
    engine, which might allow the execution of arbitrary code.
    "hong" and Gregory Fleisher discovered that file input focus
    vulnerabilities in the file upload control could allow information
    disclosure of local files.
    "moz_bug_r_a4" and Boris Zbarsky discovered discovered several
    vulnerabilities in Javascript handling, which could allow
    privilege escalation.
    Justin Dolske discovered that the password storage mechanism could
    be abused by malicious web sites to corrupt existing saved passwords.
    Gerry Eisenhaur and "moz_bug_r_a4" discovered that a directory
    traversal vulnerability in chrome: URI handling could lead to
    information disclosure.
    David Bloom discovered a race condition in the image handling of
    designMode elements, which can lead to information disclosure or
    potentially the execution of arbitrary code.
    Michal Zalewski discovered that timers protecting security-sensitive
    dialogs (which disable dialog elements until a timeout is reached)
    could be bypassed by window focus changes through Javascript.
    It was discovered that malformed content declarations of saved
    attachments could prevent a user in the opening local files
    with a ".txt" file name, resulting in minor denial of service.
    Martin Straka discovered that insecure stylesheet handling during
    redirects could lead to information disclosure.
    Emil Ljungdahl and Lars-Olof Moilanen discovered that phishing
    protections could be bypassed with <div> elements.
The Mozilla releases from the old stable distribution (sarge) are no
longer supported with security updates.
For the stable distribution (etch), these problems have been fixed in
version 1.0.12~pre080131b-0etch1.
We recommend that you upgrade your iceape packages.


Solution : http://www.debian.org/security/2008/dsa-1506
Risk factor : High';

if (description) {
 script_id(31150);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1506");
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1506] DSA-1506-1 iceape");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1506-1 iceape");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'iceape', release: '4.0', reference: '1.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape is vulnerable in Debian etch.\nUpgrade to iceape_1.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
