# This script was automatically generated from the dsa-1508
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Dan Dennison discovered that Diatheke, a CGI program to make a bible
website, performs insufficient sanitising of a parameter, allowing a
remote attacker to execute arbitrary shell commands as the web server
user.
For the stable distribution (etch), this problem has been fixed in version
1.5.9-2etch1.
For the old stable distribution (sarge), this problem has been fixed in
version 1.5.7-7sarge1.
For the unstable distribution (sid), this problem has been fixed in version
1.5.9-8.
We recommend that you upgrade your diatheke package.


Solution : http://www.debian.org/security/2008/dsa-1508
Risk factor : High';

if (description) {
 script_id(31169);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1508");
 script_cve_id("CVE-2008-0932");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1508] DSA-1508-1 diatheke");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1508-1 diatheke");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'diatheke', release: '3.1', reference: '1.5.7-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package diatheke is vulnerable in Debian 3.1.\nUpgrade to diatheke_1.5.7-7sarge1\n');
}
if (deb_check(prefix: 'libsword-dev', release: '3.1', reference: '1.5.7-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsword-dev is vulnerable in Debian 3.1.\nUpgrade to libsword-dev_1.5.7-7sarge1\n');
}
if (deb_check(prefix: 'libsword4', release: '3.1', reference: '1.5.7-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsword4 is vulnerable in Debian 3.1.\nUpgrade to libsword4_1.5.7-7sarge1\n');
}
if (deb_check(prefix: 'diatheke', release: '4.0', reference: '1.5.9-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package diatheke is vulnerable in Debian 4.0.\nUpgrade to diatheke_1.5.9-2etch1\n');
}
if (deb_check(prefix: 'libsword-dev', release: '4.0', reference: '1.5.9-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsword-dev is vulnerable in Debian 4.0.\nUpgrade to libsword-dev_1.5.9-2etch1\n');
}
if (deb_check(prefix: 'libsword6', release: '4.0', reference: '1.5.9-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsword6 is vulnerable in Debian 4.0.\nUpgrade to libsword6_1.5.9-2etch1\n');
}
if (deb_check(prefix: 'diatheke', release: '4.0', reference: '1.5.9-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package diatheke is vulnerable in Debian etch.\nUpgrade to diatheke_1.5.9-2etch1\n');
}
if (deb_check(prefix: 'diatheke', release: '3.1', reference: '1.5.7-7sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package diatheke is vulnerable in Debian sarge.\nUpgrade to diatheke_1.5.7-7sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
