# This script was automatically generated from the dsa-1513
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that lighttpd, a fast webserver with minimal memory
footprint, would display the source to CGI scripts if their execution
failed in some circumstances.
For the stable distribution (etch), this problem has been fixed in version
1.4.13-4etch5.
For the unstable distribution, this problem will be fixed soon.
We recommend that you upgrade your lighttpd package.


Solution : http://www.debian.org/security/2008/dsa-1513
Risk factor : High';

if (description) {
 script_id(31360);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1513");
 script_cve_id("CVE-2008-1111");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1513] DSA-1513-1 lighttpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1513-1 lighttpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'lighttpd', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd is vulnerable in Debian 4.0.\nUpgrade to lighttpd_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-doc', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-doc is vulnerable in Debian 4.0.\nUpgrade to lighttpd-doc_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-mod-cml', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-cml is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-cml_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-mod-magnet', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-magnet is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-magnet_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-mod-mysql-vhost', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-mysql-vhost is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-mysql-vhost_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-mod-trigger-b4-dl', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-trigger-b4-dl is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-trigger-b4-dl_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd-mod-webdav', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-webdav is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-webdav_1.4.13-4etch5\n');
}
if (deb_check(prefix: 'lighttpd', release: '4.0', reference: '1.4.13-4etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd is vulnerable in Debian etch.\nUpgrade to lighttpd_1.4.13-4etch5\n');
}
if (w) { security_hole(port: 0, data: desc); }
