#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains an ASP application that is affected by
a SQL injection vulnerability. 

Description :

The remote host is running DevTrack, a defect and project tracking
tool. 

The DevTrack Web Services component installed on the remote host
contains an ASP script that fails to sanitize user-supplied input to
the 'UserName' parameter before using it in a database query.  An
unauthenticated remote attacker may be able to leverage this flaw to
manipulate SQL queries and uncover sensitive information, modify data,
or even launch attacks against the underlying database. 

Solution :

The vendor is rumoured to be incorporating a fix into DevTrack version
6.2. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24322);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0853");
  script_bugtraq_id(22460);
  script_xref(name:"OSVDB", value:"33121");

  script_name(english:"DevTrack Web Service UserName SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error using DevTrack Web Service");
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Loop through various directories.
#
# nb: the app uses "/TXWebService" by default so make sure we do too.
dirs = make_list("/TXWebService", cgi_dirs());

foreach dir (dirs)
{
  # Try to generate a SQL error.
  exploit = string("'nessus", unixtime());
  req = http_get(
    item:string(
      dir, "/DataService.asmx/AuthUser?",
      "UserName=", urlencode(str:exploit), "&",
      # nb: leave it empty to return data.
      "Password=nasl&",
      "NeedCompress=0"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see a SQL error.
  if (
    "ReturnMessage>Database Error" >< res &&
    string("Incorrect syntax near ", exploit, "'") >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
