#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17631);
 script_cve_id("CVE-2005-0876", "CVE-2005-0877");
 script_bugtraq_id(12897);
 script_version ("$Revision: 1.6 $");
 
 name["english"] = "dnsmasq Multiple Remote Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote DNS / DHCP service is affected by multiple vulnerabilities. 

Description :

The remote host is running dnsmasq, a DHCP and DNS server. 

The version of dnsmasq installed on the remote host contains an
off-by-one boundary error when reading a DHCP lease file.  An attacker
can leverage this issue to cause the application to crash or possible
execute arbitrary code the next time it is restarted by sending a long
hostname and client-id when requesting a DHCP lease. 

In addition, the application only checks the 16-bit ID against current
queries when receiving DNS replies.  An attacker may be able to send a
flood of DNS replies and poison the DNS cache. 

See also :

http://secunia.com/advisories/14691
http://www.thekelleys.org.uk/dnsmasq/CHANGELOG

Solution :

Upgrade to dnsmasq 2.21.0 or newer. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of dnsmasq"; 
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "Gain a shell remotely";
 script_family(english:family["english"]);

 script_dependencie("bind_version.nasl");
 script_require_keys("bind/version");
 exit(0);
}



# dnsmasq replies to BIND.VERSION
vers = get_kb_item("bind/version");
if ( vers && ereg(pattern:"dnsmasq-([01]\.|2\.([0-9]$|1[0-9]$|20))", string:vers) )
	security_hole(port:53, proto:"udp");
