#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31116);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0850");
  script_bugtraq_id(27792);
  script_xref(name:"Secunia", value:"28974");

  script_name(english:"Dokeos Referer SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL syntax error");

  desc = "
Synopsis :

The remote web server contains a PHP application that is susceptible
to a SQL injection attack. 

Description :

The remote host is running Dokeos, an open-source, e-learning and
course management web application written in PHP. 

The version of Dokeos installed on the remote host fails to sanitize
user input to the 'Referer' request header before using it in the
'main/inc/lib/events.lib.inc.php' script to perform database queries. 
Regardless of PHP's 'magic_quotes_gpc' setting, an attacker may be
able to exploit this issue to manipulate database queries to disclose
sensitive information, or even attack the underlying database. 

Note that there are also reportedly several other vulnerabilities
associated with this version of Dokeos, although Nessus has not
checked for them. 

See also :

http://projects.dokeos.com/index.php?do=details&task_id=2218

Solution :

Apply Dokeos 1.8.4 SP2 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/dokeos", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to generate a SQL error.
  req = http_get(item:string(dir, "/index.php"), port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Referer: '", SCRIPT_NAME, "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we get a syntax error
  if (
    "main/inc/lib/events.lib.inc.php" >< res &&
    (
      "SQL error" >< res ||
      string("syntax to use near '", SCRIPT_NAME) >< res
    )
  )
  {
    security_hole(port);
    exit(0);
  }
}
