#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote IMAP server is affected by a buffer overflow vulnerability. 

Description :

The IMAP server component of IBM Lotus Domino Server installed on the
remote host fails to check the length of the supplied username in its
CRAM-MD5 authentication mechanism before processing it.  By supplying
a username over 256 bytes, an unauthenticated remote attacker can
leverage this issue to crash the affected service and possibly execute
arbitrary code remotely. 

See also :

http://www.zerodayinitiative.com/advisories/ZDI-07-011.html
http://archives.neohapsis.com/archives/bugtraq/2007-03/0370.html
http://www-1.ibm.com/support/docview.wss?uid=swg21257028

Solution :

Upgrade to Lotus Domino 6.5.6 / 7.0.2 Fix Pack 1 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(24903);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-1675");
  script_bugtraq_id(23172);
  script_xref(name:"OSVDB", value:"34091");

  script_name(english:"Lotus Domino IMAP Server CRAM-MD5 Authentication Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of Domino IMAP Server");

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/imap", 143);

  exit(0);
}


include("imap_func.inc");


port = get_kb_item("Services/imap");
if (!port) port = 143;
if (!get_port_state(port)) exit(0);


# Do a banner check.
banner = get_imap_banner(port:port);
if (!banner || " Domino IMAP4 Server Release " >!< banner) exit(0);

ver = strstr(banner, "Server Release ") - "Server Release ";
ver = ver - strstr(ver, " ready");
if (ver && egrep(pattern:"^(6\.5\.[0-5]($|[^0-9])|7\.0\.([01]($|[^0-9])|2$))", string:ver))
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "According to the banner from its IMAP server, Domino ", ver, " is\n",
    "installed on the remote host.\n"
  );
  security_hole(port:port, data:report);
}
